/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.Arrays;
import org.apache.hyracks.api.dataset.DatasetDirectoryRecord;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.dataset.IDatasetDirectoryService;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class GetResultPartitionLocationsWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final ResultSetId rsId;
    private final DatasetDirectoryRecord[] knownRecords;
    private final IResultCallback<DatasetDirectoryRecord[]> callback;

    public GetResultPartitionLocationsWork(ClusterControllerService ccs, JobId jobId, ResultSetId rsId, DatasetDirectoryRecord[] knownRecords, IResultCallback<DatasetDirectoryRecord[]> callback) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.rsId = rsId;
        this.knownRecords = knownRecords;
        this.callback = callback;
    }

    public void doRun() {
        final IDatasetDirectoryService dds = this.ccs.getDatasetDirectoryService();
        this.ccs.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    dds.getResultPartitionLocations(GetResultPartitionLocationsWork.this.jobId, GetResultPartitionLocationsWork.this.rsId, GetResultPartitionLocationsWork.this.knownRecords, (IResultCallback<DatasetDirectoryRecord[]>)GetResultPartitionLocationsWork.this.callback);
                }
                catch (HyracksDataException e) {
                    GetResultPartitionLocationsWork.this.callback.setException((Exception)((Object)e));
                }
            }
        });
    }

    public String toString() {
        return this.getName() + ": JobId@" + this.jobId + " ResultSetId@" + this.rsId + " Known@" + Arrays.toString(this.knownRecords);
    }
}

