/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class DestroyJobWork
extends SynchronizableWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final IResultCallback<JobId> callback;

    public DestroyJobWork(ClusterControllerService ccs, JobId jobId, IResultCallback<JobId> callback) {
        this.jobId = jobId;
        this.ccs = ccs;
        this.callback = callback;
    }

    protected void doRun() throws Exception {
        try {
            this.ccs.getPreDistributedJobStore().removeDistributedJobDescriptor(this.jobId);
            INodeManager nodeManager = this.ccs.getNodeManager();
            for (NodeControllerState node : nodeManager.getAllNodeControllerStates()) {
                node.getNodeController().destroyJob(this.jobId);
            }
            this.callback.setValue((Object)this.jobId);
        }
        catch (Exception e) {
            this.callback.setException(e);
        }
    }
}

