/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.web;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.web.ApplicationInstallationHandler;
import org.apache.hyracks.control.cc.web.JobsRESTAPIFunction;
import org.apache.hyracks.control.cc.web.NodesRESTAPIFunction;
import org.apache.hyracks.control.cc.web.StateDumpRESTAPIFunction;
import org.apache.hyracks.control.cc.web.util.IJSONOutputFunction;
import org.apache.hyracks.control.cc.web.util.JSONOutputRequestHandler;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.HttpServer;
import org.apache.hyracks.http.server.StaticResourceServlet;
import org.apache.hyracks.http.server.WebManager;

public class WebServer {
    private final ClusterControllerService ccs;
    private final int listeningPort;
    private final ConcurrentMap<String, Object> ctx;
    private final WebManager webMgr;
    private final HttpServer server;

    public WebServer(ClusterControllerService ccs, int port) throws Exception {
        this.ccs = ccs;
        this.listeningPort = port;
        this.ctx = new ConcurrentHashMap<String, Object>();
        this.webMgr = new WebManager();
        this.server = new HttpServer(this.webMgr.getBosses(), this.webMgr.getWorkers(), this.listeningPort);
        this.addHandlers();
        this.webMgr.add(this.server);
    }

    private void addHandlers() {
        this.addJSONHandler("/rest/jobs/*", new JobsRESTAPIFunction(this.ccs));
        this.addJSONHandler("/rest/nodes/*", new NodesRESTAPIFunction(this.ccs));
        this.addJSONHandler("/rest/statedump", new StateDumpRESTAPIFunction(this.ccs));
        this.server.addServlet((IServlet)new StaticResourceServlet(this.ctx, new String[]{"/static/*"}));
        this.server.addServlet((IServlet)new ApplicationInstallationHandler(this.ctx, new String[]{"/applications/*"}, this.ccs));
    }

    private void addJSONHandler(String path, IJSONOutputFunction fn) {
        this.server.addServlet((IServlet)new JSONOutputRequestHandler(this.ctx, new String[]{path}, fn));
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public void start() throws Exception {
        this.webMgr.start();
    }

    public void stop() throws Exception {
        this.webMgr.stop();
    }
}

