/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.web.util.IJSONOutputFunction;
import org.apache.hyracks.control.cc.work.GatherStateDumpsWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class StateDumpRESTAPIFunction
implements IJSONOutputFunction {
    private final ClusterControllerService ccs;

    public StateDumpRESTAPIFunction(ClusterControllerService ccs) {
        this.ccs = ccs;
    }

    @Override
    public ObjectNode invoke(String host, String servletPath, String[] arguments) throws Exception {
        GatherStateDumpsWork gsdw = new GatherStateDumpsWork(this.ccs);
        this.ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gsdw);
        GatherStateDumpsWork.StateDumpRun sdr = gsdw.getStateDumpRun();
        sdr.waitForCompletion();
        ObjectMapper om = new ObjectMapper();
        ObjectNode result = om.createObjectNode();
        for (Map.Entry<String, String> e : sdr.getStateDump().entrySet()) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }
}

