/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.scheduler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.scheduler.IJobQueue;

public class FIFOJobQueue
implements IJobQueue {
    private static final Logger LOGGER = Logger.getLogger(FIFOJobQueue.class.getName());
    private final Map<JobId, JobRun> jobListMap = new LinkedHashMap<JobId, JobRun>();
    private final IJobManager jobManager;
    private final IJobCapacityController jobCapacityController;
    private final int jobQueueCapacity;

    public FIFOJobQueue(IJobManager jobManager, IJobCapacityController jobCapacityController) {
        this.jobManager = jobManager;
        this.jobCapacityController = jobCapacityController;
        this.jobQueueCapacity = jobManager.getJobQueueCapacity();
    }

    @Override
    public void add(JobRun run) throws HyracksException {
        int size = this.jobListMap.size();
        if (size >= this.jobQueueCapacity) {
            throw HyracksException.create((int)6, (Serializable[])new Serializable[]{Integer.valueOf(this.jobQueueCapacity)});
        }
        this.jobListMap.put(run.getJobId(), run);
    }

    @Override
    public JobRun remove(JobId jobId) {
        return this.jobListMap.remove(jobId);
    }

    @Override
    public JobRun get(JobId jobId) {
        return this.jobListMap.get(jobId);
    }

    @Override
    public List<JobRun> pull() {
        ArrayList<JobRun> jobRuns = new ArrayList<JobRun>();
        Iterator<JobRun> runIterator = this.jobListMap.values().iterator();
        while (runIterator.hasNext()) {
            JobRun run = runIterator.next();
            JobSpecification job = run.getJobSpecification();
            try {
                IJobCapacityController.JobSubmissionStatus status = this.jobCapacityController.allocate(job);
                if (status != IJobCapacityController.JobSubmissionStatus.EXECUTE) continue;
                jobRuns.add(run);
                runIterator.remove();
            }
            catch (HyracksException exception) {
                ArrayList<Exception> exceptions = new ArrayList<Exception>();
                exceptions.add((Exception)((Object)exception));
                runIterator.remove();
                try {
                    this.jobManager.prepareComplete(run, JobStatus.FAILURE_BEFORE_EXECUTION, exceptions);
                }
                catch (HyracksException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return jobRuns;
    }

    @Override
    public Collection<JobRun> jobs() {
        return Collections.unmodifiableCollection(this.jobListMap.values());
    }
}

