/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.common.base.INodeController;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.heartbeat.HeartbeatSchema;

public class NodeControllerState {
    private static final int RRD_SIZE = 720;
    private final INodeController nodeController;
    private final NCConfig ncConfig;
    private final NetworkAddress dataPort;
    private final NetworkAddress datasetPort;
    private final NetworkAddress messagingPort;
    private final Set<JobId> activeJobIds;
    private final String osName;
    private final String arch;
    private final String osVersion;
    private final int nProcessors;
    private final String vmName;
    private final String vmVersion;
    private final String vmVendor;
    private final String classpath;
    private final String libraryPath;
    private final String bootClasspath;
    private final List<String> inputArguments;
    private final Map<String, String> systemProperties;
    private final int pid;
    private final HeartbeatSchema hbSchema;
    private final long[] hbTime;
    private final long[] heapInitSize;
    private final long[] heapUsedSize;
    private final long[] heapCommittedSize;
    private final long[] heapMaxSize;
    private final long[] nonheapInitSize;
    private final long[] nonheapUsedSize;
    private final long[] nonheapCommittedSize;
    private final long[] nonheapMaxSize;
    private final int[] threadCount;
    private final int[] peakThreadCount;
    private final double[] systemLoadAverage;
    private final String[] gcNames;
    private final long[][] gcCollectionCounts;
    private final long[][] gcCollectionTimes;
    private final long[] netPayloadBytesRead;
    private final long[] netPayloadBytesWritten;
    private final long[] netSignalingBytesRead;
    private final long[] netSignalingBytesWritten;
    private final long[] datasetNetPayloadBytesRead;
    private final long[] datasetNetPayloadBytesWritten;
    private final long[] datasetNetSignalingBytesRead;
    private final long[] datasetNetSignalingBytesWritten;
    private final long[] ipcMessagesSent;
    private final long[] ipcMessageBytesSent;
    private final long[] ipcMessagesReceived;
    private final long[] ipcMessageBytesReceived;
    private final long[] diskReads;
    private final long[] diskWrites;
    private int rrdPtr;
    private int lastHeartbeatDuration;
    private NodeCapacity capacity;

    public NodeControllerState(INodeController nodeController, NodeRegistration reg) {
        this.nodeController = nodeController;
        this.ncConfig = reg.getNCConfig();
        this.dataPort = reg.getDataPort();
        this.datasetPort = reg.getDatasetPort();
        this.messagingPort = reg.getMessagingPort();
        this.activeJobIds = new HashSet<JobId>();
        this.osName = reg.getOSName();
        this.arch = reg.getArch();
        this.osVersion = reg.getOSVersion();
        this.nProcessors = reg.getNProcessors();
        this.vmName = reg.getVmName();
        this.vmVersion = reg.getVmVersion();
        this.vmVendor = reg.getVmVendor();
        this.classpath = reg.getClasspath();
        this.libraryPath = reg.getLibraryPath();
        this.bootClasspath = reg.getBootClasspath();
        this.inputArguments = reg.getInputArguments();
        this.systemProperties = reg.getSystemProperties();
        this.pid = reg.getPid();
        this.hbSchema = reg.getHeartbeatSchema();
        this.hbTime = new long[720];
        this.heapInitSize = new long[720];
        this.heapUsedSize = new long[720];
        this.heapCommittedSize = new long[720];
        this.heapMaxSize = new long[720];
        this.nonheapInitSize = new long[720];
        this.nonheapUsedSize = new long[720];
        this.nonheapCommittedSize = new long[720];
        this.nonheapMaxSize = new long[720];
        this.threadCount = new int[720];
        this.peakThreadCount = new int[720];
        this.systemLoadAverage = new double[720];
        HeartbeatSchema.GarbageCollectorInfo[] gcInfos = this.hbSchema.getGarbageCollectorInfos();
        int gcN = gcInfos.length;
        this.gcNames = new String[gcN];
        for (int i = 0; i < gcN; ++i) {
            this.gcNames[i] = gcInfos[i].getName();
        }
        this.gcCollectionCounts = new long[gcN][720];
        this.gcCollectionTimes = new long[gcN][720];
        this.netPayloadBytesRead = new long[720];
        this.netPayloadBytesWritten = new long[720];
        this.netSignalingBytesRead = new long[720];
        this.netSignalingBytesWritten = new long[720];
        this.datasetNetPayloadBytesRead = new long[720];
        this.datasetNetPayloadBytesWritten = new long[720];
        this.datasetNetSignalingBytesRead = new long[720];
        this.datasetNetSignalingBytesWritten = new long[720];
        this.ipcMessagesSent = new long[720];
        this.ipcMessageBytesSent = new long[720];
        this.ipcMessagesReceived = new long[720];
        this.ipcMessageBytesReceived = new long[720];
        this.diskReads = new long[720];
        this.diskWrites = new long[720];
        this.rrdPtr = 0;
        this.capacity = reg.getCapacity();
    }

    public synchronized void notifyHeartbeat(HeartbeatData hbData) {
        this.lastHeartbeatDuration = 0;
        this.hbTime[this.rrdPtr] = System.currentTimeMillis();
        if (hbData != null) {
            this.heapInitSize[this.rrdPtr] = hbData.heapInitSize;
            this.heapUsedSize[this.rrdPtr] = hbData.heapUsedSize;
            this.heapCommittedSize[this.rrdPtr] = hbData.heapCommittedSize;
            this.heapMaxSize[this.rrdPtr] = hbData.heapMaxSize;
            this.nonheapInitSize[this.rrdPtr] = hbData.nonheapInitSize;
            this.nonheapUsedSize[this.rrdPtr] = hbData.nonheapUsedSize;
            this.nonheapCommittedSize[this.rrdPtr] = hbData.nonheapCommittedSize;
            this.nonheapMaxSize[this.rrdPtr] = hbData.nonheapMaxSize;
            this.threadCount[this.rrdPtr] = hbData.threadCount;
            this.peakThreadCount[this.rrdPtr] = hbData.peakThreadCount;
            this.systemLoadAverage[this.rrdPtr] = hbData.systemLoadAverage;
            int gcN = this.hbSchema.getGarbageCollectorInfos().length;
            for (int i = 0; i < gcN; ++i) {
                this.gcCollectionCounts[i][this.rrdPtr] = hbData.gcCollectionCounts[i];
                this.gcCollectionTimes[i][this.rrdPtr] = hbData.gcCollectionTimes[i];
            }
            this.netPayloadBytesRead[this.rrdPtr] = hbData.netPayloadBytesRead;
            this.netPayloadBytesWritten[this.rrdPtr] = hbData.netPayloadBytesWritten;
            this.netSignalingBytesRead[this.rrdPtr] = hbData.netSignalingBytesRead;
            this.netSignalingBytesWritten[this.rrdPtr] = hbData.netSignalingBytesWritten;
            this.datasetNetPayloadBytesRead[this.rrdPtr] = hbData.datasetNetPayloadBytesRead;
            this.datasetNetPayloadBytesWritten[this.rrdPtr] = hbData.datasetNetPayloadBytesWritten;
            this.datasetNetSignalingBytesRead[this.rrdPtr] = hbData.datasetNetSignalingBytesRead;
            this.datasetNetSignalingBytesWritten[this.rrdPtr] = hbData.datasetNetSignalingBytesWritten;
            this.ipcMessagesSent[this.rrdPtr] = hbData.ipcMessagesSent;
            this.ipcMessageBytesSent[this.rrdPtr] = hbData.ipcMessageBytesSent;
            this.ipcMessagesReceived[this.rrdPtr] = hbData.ipcMessagesReceived;
            this.ipcMessageBytesReceived[this.rrdPtr] = hbData.ipcMessageBytesReceived;
            this.diskReads[this.rrdPtr] = hbData.diskReads;
            this.diskWrites[this.rrdPtr] = hbData.diskWrites;
            this.rrdPtr = (this.rrdPtr + 1) % 720;
        }
    }

    public int incrementLastHeartbeatDuration() {
        return this.lastHeartbeatDuration++;
    }

    public INodeController getNodeController() {
        return this.nodeController;
    }

    public NCConfig getNCConfig() {
        return this.ncConfig;
    }

    public Set<JobId> getActiveJobIds() {
        return this.activeJobIds;
    }

    public NetworkAddress getDataPort() {
        return this.dataPort;
    }

    public NetworkAddress getDatasetPort() {
        return this.datasetPort;
    }

    public NetworkAddress getMessagingPort() {
        return this.messagingPort;
    }

    public NodeCapacity getCapacity() {
        return this.capacity;
    }

    public synchronized ObjectNode toSummaryJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode o = om.createObjectNode();
        o.put("node-id", this.ncConfig.getNodeId());
        o.put("heap-used", this.heapUsedSize[(this.rrdPtr + 720 - 1) % 720]);
        o.put("system-load-average", this.systemLoadAverage[(this.rrdPtr + 720 - 1) % 720]);
        return o;
    }

    public synchronized ObjectNode toDetailedJSON(boolean includeStats, boolean includeConfig) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode o = om.createObjectNode();
        o.put("node-id", this.ncConfig.getNodeId());
        if (includeConfig) {
            o.put("os-name", this.osName);
            o.put("arch", this.arch);
            o.put("os-version", this.osVersion);
            o.put("num-processors", this.nProcessors);
            o.put("vm-name", this.vmName);
            o.put("vm-version", this.vmVersion);
            o.put("vm-vendor", this.vmVendor);
            o.putPOJO("classpath", (Object)this.classpath.split(File.pathSeparator));
            o.putPOJO("library-path", (Object)this.libraryPath.split(File.pathSeparator));
            o.putPOJO("boot-classpath", (Object)this.bootClasspath.split(File.pathSeparator));
            o.putPOJO("input-arguments", this.inputArguments);
            o.putPOJO("system-properties", this.systemProperties);
            o.put("pid", this.pid);
        }
        if (includeStats) {
            o.putPOJO("date", (Object)new Date());
            o.put("rrd-ptr", this.rrdPtr);
            o.putPOJO("heartbeat-times", (Object)this.hbTime);
            o.putPOJO("heap-init-sizes", (Object)this.heapInitSize);
            o.putPOJO("heap-used-sizes", (Object)this.heapUsedSize);
            o.putPOJO("heap-committed-sizes", (Object)this.heapCommittedSize);
            o.putPOJO("heap-max-sizes", (Object)this.heapMaxSize);
            o.putPOJO("nonheap-init-sizes", (Object)this.nonheapInitSize);
            o.putPOJO("nonheap-used-sizes", (Object)this.nonheapUsedSize);
            o.putPOJO("nonheap-committed-sizes", (Object)this.nonheapCommittedSize);
            o.putPOJO("nonheap-max-sizes", (Object)this.nonheapMaxSize);
            o.putPOJO("application-memory-budget", (Object)this.capacity.getMemoryByteSize());
            o.putPOJO("application-cpu-core-budget", (Object)this.capacity.getCores());
            o.putPOJO("thread-counts", (Object)this.threadCount);
            o.putPOJO("peak-thread-counts", (Object)this.peakThreadCount);
            o.putPOJO("system-load-averages", (Object)this.systemLoadAverage);
            o.putPOJO("gc-names", (Object)this.gcNames);
            o.putPOJO("gc-collection-counts", (Object)this.gcCollectionCounts);
            o.putPOJO("gc-collection-times", (Object)this.gcCollectionTimes);
            o.putPOJO("net-payload-bytes-read", (Object)this.netPayloadBytesRead);
            o.putPOJO("net-payload-bytes-written", (Object)this.netPayloadBytesWritten);
            o.putPOJO("net-signaling-bytes-read", (Object)this.netSignalingBytesRead);
            o.putPOJO("net-signaling-bytes-written", (Object)this.netSignalingBytesWritten);
            o.putPOJO("dataset-net-payload-bytes-read", (Object)this.datasetNetPayloadBytesRead);
            o.putPOJO("dataset-net-payload-bytes-written", (Object)this.datasetNetPayloadBytesWritten);
            o.putPOJO("dataset-net-signaling-bytes-read", (Object)this.datasetNetSignalingBytesRead);
            o.putPOJO("dataset-net-signaling-bytes-written", (Object)this.datasetNetSignalingBytesWritten);
            o.putPOJO("ipc-messages-sent", (Object)this.ipcMessagesSent);
            o.putPOJO("ipc-message-bytes-sent", (Object)this.ipcMessageBytesSent);
            o.putPOJO("ipc-messages-received", (Object)this.ipcMessagesReceived);
            o.putPOJO("ipc-message-bytes-received", (Object)this.ipcMessageBytesReceived);
            o.putPOJO("disk-reads", (Object)this.diskReads);
            o.putPOJO("disk-writes", (Object)this.diskWrites);
        }
        return o;
    }
}

