/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.event.error.VerificationUtil;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.StartNodeConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.error.InstallerException;

public class StartNodeCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((StartNodeConfig)this.config).name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE, AsterixInstance.State.ACTIVE, AsterixInstance.State.UNUSABLE});
        Cluster cluster = instance.getCluster();
        ArrayList<Pattern> pl = new ArrayList<Pattern>();
        AsterixRuntimeState runtimeState = VerificationUtil.getAsterixRuntimeState((AsterixInstance)instance);
        String[] nodesToBeAdded = ((StartNodeConfig)this.config).nodes.split(",");
        ArrayList<String> aliveNodes = new ArrayList<String>();
        for (String[] p : runtimeState.getProcesses()) {
            aliveNodes.add(p.getNodeId());
        }
        List clusterNodes = cluster.getNode();
        block1: for (String n : nodesToBeAdded) {
            if (aliveNodes.contains(n)) {
                throw new InstallerException("Node: " + n + " is already alive");
            }
            for (Node node : clusterNodes) {
                if (!n.equals(node.getId())) continue;
                String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
                Pattern createNC = PatternCreator.INSTANCE.createNCStartPattern(cluster.getMasterNode().getClusterIp(), node.getId(), asterixInstanceName + "_" + node.getId(), iodevices, false);
                pl.add(createNC);
                continue block1;
            }
        }
        Patterns patterns = new Patterns(pl);
        AsterixEventServiceClient client = AsterixEventService.getAsterixEventServiceClient((Cluster)cluster);
        client.submit(patterns);
        runtimeState = VerificationUtil.getAsterixRuntimeState((AsterixInstance)instance);
        VerificationUtil.updateInstanceWithRuntimeDescription((AsterixInstance)instance, (AsterixRuntimeState)runtimeState, (boolean)true);
        LOGGER.info((Object)instance.getDescription(false));
        ServiceProvider.INSTANCE.getLookupService().updateAsterixInstance(instance);
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new StartNodeConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nStarts a set of nodes for an ASTERIX instance.\n\nAvailable arguments/options\n-n name of the ASTERIX instance. \n-nodesComma separated list of nodes that need to be started";
    }
}

