/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.installer.command;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.command.AbstractCommand;
import org.apache.asterix.installer.command.CommandConfig;
import org.apache.asterix.installer.command.LogConfig;
import org.apache.asterix.installer.driver.InstallerDriver;
import org.apache.asterix.installer.error.InstallerException;
import org.apache.commons.io.FileUtils;

public class LogCommand
extends AbstractCommand {
    @Override
    protected void execCommand() throws Exception {
        String[] filesToDelete;
        boolean success;
        InstallerDriver.initConfig(true);
        String asterixInstanceName = ((LogConfig)this.config).name;
        AsterixInstance instance = AsterixEventServiceUtil.validateAsterixInstanceExists((String)asterixInstanceName, (AsterixInstance.State[])new AsterixInstance.State[]{AsterixInstance.State.INACTIVE, AsterixInstance.State.UNUSABLE, AsterixInstance.State.ACTIVE});
        PatternCreator pc = PatternCreator.INSTANCE;
        AsterixEventServiceClient eventrixClient = AsterixEventService.getAsterixEventServiceClient((Cluster)instance.getCluster(), (boolean)true, (boolean)false);
        String outputDir = ((LogConfig)this.config).outputDir == null ? InstallerDriver.getManagixHome() + File.separator + "logdump" : ((LogConfig)this.config).outputDir;
        File f = new File(outputDir);
        String outputDirPath = f.getAbsolutePath();
        if (!f.exists() && !(success = f.mkdirs())) {
            throw new InstallerException("Unable to create output directory:" + outputDirPath);
        }
        Patterns transferLogPattern = pc.getGenerateLogPattern(instance.getCluster(), outputDirPath);
        eventrixClient.submit(transferLogPattern);
        File outputDirFile = new File(outputDirPath);
        final String destFileName = "log_" + new Date().toString().replace(' ', '_') + ".zip";
        File destFile = new File(outputDirFile, destFileName);
        AsterixEventServiceUtil.zipDir((File)outputDirFile, (File)destFile);
        for (String fileS : filesToDelete = outputDirFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.equals(destFileName);
            }
        })) {
            f = new File(outputDirFile, fileS);
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
                continue;
            }
            f.delete();
        }
        LOGGER.info((Object)("Log zip archive created at " + destFile.getAbsolutePath()));
    }

    @Override
    protected CommandConfig getCommandConfig() {
        return new LogConfig();
    }

    @Override
    protected String getUsageDescription() {
        return "\nCreates a tar ball containing log files corresponding to each worker node (NC) and the master (CC)  for an ASTERIX instance\n\nAvailable arguments/options\n-n name of the ASTERIX instance. \n-d destination directory for producing the tar ball (defaults to) " + InstallerDriver.getManagixHome();
    }
}

