/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import java.io.Serializable;
import java.util.List;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;
import org.apache.hyracks.storage.common.file.LocalResource;

public abstract class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int datasetId;
    private final int partition;
    protected final ITypeTraits[] filterTypeTraits;
    protected final IBinaryComparatorFactory[] filterCmpFactories;
    protected final int[] filterFields;
    protected final ILSMOperationTrackerFactory opTrackerProvider;
    protected final ILSMIOOperationCallbackFactory ioOpCallbackFactory;
    protected final IMetadataPageManagerFactory metadataPageManagerFactory;

    public Resource(int datasetId, int partition, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, ILSMOperationTrackerFactory opTrackerProvider, ILSMIOOperationCallbackFactory ioOpCallbackFactory, IMetadataPageManagerFactory metadataPageManagerFactory) {
        this.datasetId = datasetId;
        this.partition = partition;
        this.filterTypeTraits = filterTypeTraits;
        this.filterCmpFactories = filterCmpFactories;
        this.filterFields = filterFields;
        this.opTrackerProvider = opTrackerProvider;
        this.ioOpCallbackFactory = ioOpCallbackFactory;
        this.metadataPageManagerFactory = metadataPageManagerFactory;
    }

    public int partition() {
        return this.partition;
    }

    public int datasetId() {
        return this.datasetId;
    }

    public abstract ILSMIndex createIndexInstance(INCServiceContext var1, LocalResource var2) throws HyracksDataException;

    public static int getIoDeviceNum(IIOManager ioManager, IODeviceHandle deviceHandle) {
        List ioDevices = ioManager.getIODevices();
        for (int i = 0; i < ioDevices.size(); ++i) {
            IODeviceHandle device = (IODeviceHandle)ioDevices.get(i);
            if (device != deviceHandle) continue;
            return i;
        }
        return -1;
    }
}

