/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.replication;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.replication.Replica;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ChainedDeclusteringReplicationStrategy
implements IReplicationStrategy {
    private static final Logger LOGGER = Logger.getLogger(ChainedDeclusteringReplicationStrategy.class.getName());
    private int replicationFactor;

    @Override
    public boolean isMatch(int datasetId) {
        return true;
    }

    @Override
    public Set<Replica> getRemoteReplicas(String nodeId) {
        HashSet<Replica> remoteReplicas = new HashSet<Replica>();
        Cluster cluster = ClusterProperties.INSTANCE.getCluster();
        int numberOfRemoteReplicas = this.replicationFactor - 1;
        int nodeIndex = ClusterProperties.INSTANCE.getNodeIndex(nodeId);
        if (nodeIndex == -1) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Could not find node " + nodeId + " in cluster configurations");
            }
            return Collections.emptySet();
        }
        while (remoteReplicas.size() != numberOfRemoteReplicas) {
            remoteReplicas.add(new Replica(cluster.getNode().get(++nodeIndex % cluster.getNode().size())));
        }
        return remoteReplicas;
    }

    @Override
    public Set<Replica> getRemotePrimaryReplicas(String nodeId) {
        HashSet<Replica> clientReplicas = new HashSet<Replica>();
        Cluster cluster = ClusterProperties.INSTANCE.getCluster();
        int remotePrimaryReplicasCount = this.replicationFactor - 1;
        int nodeIndex = ClusterProperties.INSTANCE.getNodeIndex(nodeId);
        while (clientReplicas.size() != remotePrimaryReplicasCount) {
            clientReplicas.add(new Replica(cluster.getNode().get(Math.abs(--nodeIndex % cluster.getNode().size()))));
        }
        return clientReplicas;
    }

    @Override
    public ChainedDeclusteringReplicationStrategy from(Cluster cluster) throws HyracksDataException {
        if (cluster.getHighAvailability().getDataReplication().getReplicationFactor() == null) {
            throw new RuntimeDataException(4004, new Serializable[]{"Replication factor must be specified."});
        }
        ChainedDeclusteringReplicationStrategy cd = new ChainedDeclusteringReplicationStrategy();
        cd.replicationFactor = cluster.getHighAvailability().getDataReplication().getReplicationFactor().intValue();
        return cd;
    }
}

