/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.List;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;

public class LSMBTreeWithBuddyIOOperationCallback
extends AbstractLSMIOOperationCallback {
    public void afterOperation(LSMOperationType opType, List<ILSMComponent> oldComponents, ILSMDiskComponent newComponent) throws HyracksDataException {
        if (newComponent != null) {
            LSMBTreeWithBuddyDiskComponent btreeComponent = (LSMBTreeWithBuddyDiskComponent)newComponent;
            this.putLSNIntoMetadata((ILSMDiskComponent)btreeComponent, oldComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getComponentLSN(List<? extends ILSMComponent> diskComponents) throws HyracksDataException {
        if (diskComponents == null) {
            LSMBTreeWithBuddyIOOperationCallback lSMBTreeWithBuddyIOOperationCallback = this;
            synchronized (lSMBTreeWithBuddyIOOperationCallback) {
                long lsn = this.mutableLastLSNs[this.readIndex];
                return lsn;
            }
        }
        long maxLSN = -1L;
        for (ILSMComponent iLSMComponent : diskComponents) {
            LSMBTreeWithBuddyDiskComponent btreeComponent = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            maxLSN = Math.max(AbstractLSMIOOperationCallback.getTreeIndexLSN((ITreeIndex)btreeComponent.getBTree()), maxLSN);
        }
        return maxLSN;
    }

    @Override
    public long getComponentFileLSNOffset(ILSMDiskComponent diskComponent, String diskComponentFilePath) throws HyracksDataException {
        if (diskComponentFilePath.endsWith("b")) {
            LSMBTreeWithBuddyDiskComponent btreeComponent = (LSMBTreeWithBuddyDiskComponent)diskComponent;
            IMetadataPageManager metadataPageManager = (IMetadataPageManager)btreeComponent.getBTree().getPageManager();
            return metadataPageManager.getFileOffset(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY);
        }
        return -1L;
    }
}

