/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.util.List;
import org.apache.asterix.common.ioopcallbacks.AbstractLSMIOOperationCallback;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.utils.ComponentMetadataUtil;

public class LSMBTreeIOOperationCallback
extends AbstractLSMIOOperationCallback {
    public void afterOperation(LSMOperationType opType, List<ILSMComponent> oldComponents, ILSMDiskComponent newComponent) throws HyracksDataException {
        if (newComponent != null) {
            LSMBTreeDiskComponent btreeComponent = (LSMBTreeDiskComponent)newComponent;
            this.putLSNIntoMetadata((ILSMDiskComponent)btreeComponent, oldComponents);
            if (opType == LSMOperationType.MERGE) {
                LongPointable markerLsn = LongPointable.FACTORY.createPointable(ComponentMetadataUtil.getLong((IComponentMetadata)oldComponents.get(0).getMetadata(), (IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (long)-1L));
                btreeComponent.getMetadata().put((IValueReference)ComponentMetadataUtil.MARKER_LSN_KEY, (IValueReference)markerLsn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getComponentLSN(List<? extends ILSMComponent> diskComponents) throws HyracksDataException {
        if (diskComponents == null) {
            LSMBTreeIOOperationCallback lSMBTreeIOOperationCallback = this;
            synchronized (lSMBTreeIOOperationCallback) {
                long lsn = this.mutableLastLSNs[this.readIndex];
                return lsn;
            }
        }
        long maxLSN = -1L;
        for (ILSMComponent iLSMComponent : diskComponents) {
            BTree btree = ((LSMBTreeDiskComponent)iLSMComponent).getBTree();
            maxLSN = Math.max(AbstractLSMIOOperationCallback.getTreeIndexLSN((ITreeIndex)btree), maxLSN);
        }
        return maxLSN;
    }

    @Override
    public long getComponentFileLSNOffset(ILSMDiskComponent diskComponent, String diskComponentFilePath) throws HyracksDataException {
        if (diskComponentFilePath.endsWith("b")) {
            LSMBTreeDiskComponent btreeComponent = (LSMBTreeDiskComponent)diskComponent;
            IMetadataPageManager metadataPageManager = (IMetadataPageManager)btreeComponent.getBTree().getPageManager();
            return metadataPageManager.getFileOffset(metadataPageManager.createMetadataFrame(), (IValueReference)LSN_KEY);
        }
        return -1L;
    }
}

