/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.common.file.IFileMapManager;

public class FileMapManager
implements IFileMapManager {
    private static final long serialVersionUID = 1L;
    private final transient IIOManager ioManager;
    private final Map<Integer, String> id2nameMap = new HashMap<Integer, String>();
    private final Map<String, Integer> name2IdMap = new HashMap<String, Integer>();
    private int idCounter = 0;

    public FileMapManager(IIOManager ioManager) {
        this.ioManager = ioManager;
    }

    public FileReference lookupFileName(int fileId) throws HyracksDataException {
        String fName = this.id2nameMap.get(fileId);
        if (fName == null) {
            throw new HyracksDataException("No mapping found for id: " + fileId);
        }
        return this.ioManager.resolveAbsolutePath(fName);
    }

    public int lookupFileId(FileReference fileRef) throws HyracksDataException {
        String fileName = fileRef.getFile().getAbsolutePath();
        Integer fileId = this.name2IdMap.get(fileName);
        if (fileId == null) {
            throw new HyracksDataException("No mapping found for name: " + fileName);
        }
        return fileId;
    }

    public boolean isMapped(FileReference fileRef) {
        String fileName = fileRef.getFile().getAbsolutePath();
        return this.name2IdMap.containsKey(fileName);
    }

    public boolean isMapped(int fileId) {
        return this.id2nameMap.containsKey(fileId);
    }

    public void unregisterFile(int fileId) throws HyracksDataException {
        String fileName = this.id2nameMap.remove(fileId);
        this.name2IdMap.remove(fileName);
    }

    public void registerFile(FileReference fileRef) throws HyracksDataException {
        Integer fileId = this.idCounter++;
        String fileName = fileRef.getFile().getAbsolutePath();
        this.id2nameMap.put(fileId, fileName);
        this.name2IdMap.put(fileName, fileId);
    }
}

