/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.DatasetLifecycleManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IResourceLifecycleManager;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;

public class CorrelatedPrefixMergePolicy
implements ILSMMergePolicy {
    private long maxMergableComponentSize;
    private int maxToleranceComponentCount;
    private final IDatasetLifecycleManager datasetLifecycleManager;
    private final int datasetID;

    public CorrelatedPrefixMergePolicy(IResourceLifecycleManager datasetLifecycleManager, int datasetID) {
        this.datasetLifecycleManager = (DatasetLifecycleManager)datasetLifecycleManager;
        this.datasetID = datasetID;
    }

    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException, IndexException {
        ArrayList immutableComponents = new ArrayList(index.getImmutableComponents());
        Collections.reverse(immutableComponents);
        for (ILSMDiskComponent c : immutableComponents) {
            if (c.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            return;
        }
        if (fullMergeIsRequested) {
            ILSMIndexAccessor accessor = index.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFullMerge(index.getIOOperationCallback());
            return;
        }
        if (!index.isPrimaryIndex()) {
            return;
        }
        long totalSize = 0L;
        int startIndex = -1;
        int minNumComponents = Integer.MAX_VALUE;
        Set<ILSMIndex> indexes = this.datasetLifecycleManager.getDatasetInfo(this.datasetID).getDatasetIndexes();
        for (ILSMIndex lsmIndex : indexes) {
            minNumComponents = Math.min(minNumComponents, lsmIndex.getImmutableComponents().size());
        }
        for (int i = 0; i < minNumComponents; ++i) {
            boolean isLastComponent;
            ILSMComponent c = (ILSMComponent)immutableComponents.get(i);
            long componentSize = ((ILSMDiskComponent)c).getComponentSize();
            if (componentSize > this.maxMergableComponentSize) {
                startIndex = i;
                totalSize = 0L;
                continue;
            }
            boolean bl = isLastComponent = i + 1 == minNumComponents;
            if ((totalSize += componentSize) <= this.maxMergableComponentSize && (!isLastComponent || i - startIndex < this.maxToleranceComponentCount)) continue;
            for (ILSMIndex lsmIndex : indexes) {
                ArrayList reversedImmutableComponents = new ArrayList(lsmIndex.getImmutableComponents());
                Collections.reverse(reversedImmutableComponents);
                ArrayList mergableComponents = new ArrayList();
                for (int j = startIndex + 1; j <= i; ++j) {
                    mergableComponents.add(reversedImmutableComponents.get(j));
                }
                Collections.reverse(mergableComponents);
                ILSMIndexAccessor accessor = lsmIndex.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                accessor.scheduleMerge(lsmIndex.getIOOperationCallback(), mergableComponents);
            }
            break;
        }
    }

    public void configure(Map<String, String> properties) {
        this.maxMergableComponentSize = Long.parseLong(properties.get("max-mergable-component-size"));
        this.maxToleranceComponentCount = Integer.parseInt(properties.get("max-tolerance-component-count"));
    }

    public boolean isMergeLagging(ILSMIndex index) {
        return false;
    }
}

