/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.List;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;

public class AsterixVirtualBufferCacheProvider
implements IVirtualBufferCacheProvider {
    private static final long serialVersionUID = 1L;
    private final int datasetID;

    public AsterixVirtualBufferCacheProvider(int datasetID) {
        this.datasetID = datasetID;
    }

    public List<IVirtualBufferCache> getVirtualBufferCaches(IHyracksTaskContext ctx, IFileSplitProvider fileSplitProvider) throws HyracksDataException {
        int partition = ctx.getTaskAttemptId().getTaskId().getPartition();
        IIOManager ioManager = ctx.getIOManager();
        FileSplit fileSplit = fileSplitProvider.getFileSplits()[partition];
        FileReference fileRef = fileSplit.getFileReference(ioManager);
        IODeviceHandle device = fileRef.getDeviceHandle();
        List devices = ioManager.getIODevices();
        int deviceId = 0;
        for (int i = 0; i < devices.size(); ++i) {
            IODeviceHandle next = (IODeviceHandle)devices.get(i);
            if (next != device) continue;
            deviceId = i;
        }
        return ((IAppRuntimeContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getDatasetLifecycleManager().getVirtualBufferCaches(this.datasetID, deviceId);
    }
}

