/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.AsterixProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.common.configuration.Coredump;
import org.apache.asterix.common.configuration.Extension;
import org.apache.asterix.common.configuration.Property;
import org.apache.asterix.common.configuration.Store;
import org.apache.asterix.common.configuration.TransactionLogDir;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.utils.ConfigUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.application.ConfigManagerApplicationConfig;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PropertiesAccessor
implements IApplicationConfig {
    private static final Logger LOGGER = Logger.getLogger((String)PropertiesAccessor.class.getName());
    private static final Map<IApplicationConfig, PropertiesAccessor> instances = new ConcurrentHashMap<IApplicationConfig, PropertiesAccessor>();
    private final Map<String, String[]> stores = new HashMap<String, String[]>();
    private final Map<String, String> coredumpConfig = new HashMap<String, String>();
    private final IApplicationConfig cfg;
    private final Map<String, String> transactionLogDirs = new HashMap<String, String>();
    private final Map<String, String> asterixBuildProperties = new HashMap<String, String>();
    private final Map<String, ClusterPartition[]> nodePartitionsMap;
    private final SortedMap<Integer, ClusterPartition> clusterPartitions = new TreeMap<Integer, ClusterPartition>();
    private final List<AsterixExtension> extensions;

    private PropertiesAccessor(IApplicationConfig cfg) throws AsterixException, IOException {
        this.cfg = cfg;
        this.nodePartitionsMap = new HashMap<String, ClusterPartition[]>();
        this.extensions = new ArrayList<AsterixExtension>();
        ConfigManager configManager = ((ConfigManagerApplicationConfig)cfg).getConfigManager();
        boolean usingConfigFile = Stream.of(ControllerConfig.Option.CONFIG_FILE, ControllerConfig.Option.CONFIG_FILE_URL).map(arg_0 -> ((ConfigManager)configManager).get(arg_0)).anyMatch(Objects::nonNull);
        AsterixConfiguration asterixConfiguration = null;
        try {
            asterixConfiguration = this.configure(System.getProperty("AsterixConfigFileName", "asterix-configuration.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!usingConfigFile && asterixConfiguration != null) {
            LOGGER.info((Object)("using old-style configuration: " + System.getProperty("AsterixConfigFileName")));
            if (asterixConfiguration.getInstanceName() != null) {
                configManager.set((IOption)MetadataProperties.Option.INSTANCE_NAME, (Object)asterixConfiguration.getInstanceName());
            }
            if (asterixConfiguration.getMetadataNode() != null) {
                configManager.set((IOption)MetadataProperties.Option.METADATA_NODE, (Object)asterixConfiguration.getMetadataNode());
            }
            List<Store> configuredStores = asterixConfiguration.getStore();
            int uniquePartitionId = 0;
            for (Store store : configuredStores) {
                String trimmedStoreDirs = store.getStoreDirs().trim();
                String[] nodeStores = trimmedStoreDirs.split(",");
                ClusterPartition[] nodePartitions = new ClusterPartition[nodeStores.length];
                for (int i = 0; i < nodePartitions.length; ++i) {
                    ClusterPartition partition = new ClusterPartition(uniquePartitionId++, store.getNcId(), i);
                    this.clusterPartitions.put(partition.getPartitionId(), partition);
                    nodePartitions[i] = partition;
                }
                this.stores.put(store.getNcId(), nodeStores);
                this.nodePartitionsMap.put(store.getNcId(), nodePartitions);
                configManager.registerVirtualNode(store.getNcId());
                configManager.set(store.getNcId(), (IOption)NCConfig.Option.VIRTUAL_NC, (Object)true);
            }
            if (asterixConfiguration.getExtensions() != null) {
                for (Extension ext : asterixConfiguration.getExtensions().getExtension()) {
                    this.extensions.add(ConfigUtil.toAsterixExtension(ext));
                }
            }
            for (Property p : asterixConfiguration.getProperty()) {
                IOption option = null;
                for (Section section : Arrays.asList(Section.COMMON, Section.CC, Section.NC)) {
                    IOption optionTemp = cfg.lookupOption(section.sectionName(), p.getName());
                    if (optionTemp == null) continue;
                    if (option != null) {
                        throw new IllegalStateException("ERROR: option found in multiple sections: " + Arrays.asList(option, optionTemp));
                    }
                    option = optionTemp;
                }
                if (option == null) {
                    LOGGER.warn((Object)("Ignoring unknown property: " + p.getName()));
                    continue;
                }
                configManager.set(option, option.type().parse(p.getValue()));
            }
            for (Coredump cd : asterixConfiguration.getCoredump()) {
                this.coredumpConfig.put(cd.getNcId(), cd.getCoredumpPath());
            }
            for (TransactionLogDir txnLogDir : asterixConfiguration.getTransactionLogDir()) {
                this.transactionLogDirs.put(txnLogDir.getNcId(), txnLogDir.getTxnLogDirPath());
            }
        } else {
            LOGGER.info((Object)"using new-style configuration");
            MutableInt uniquePartitionId = new MutableInt(0);
            for (String ncName : cfg.getNCNames()) {
                this.configureNc(ncName, uniquePartitionId);
            }
            for (String section : cfg.getSectionNames()) {
                if (!section.startsWith("extension/")) continue;
                String className = AsterixProperties.getSectionId("extension/", section);
                this.configureExtension(className, section);
            }
        }
        this.loadAsterixBuildProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AsterixConfiguration configure(String fileName) throws IOException, AsterixException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            if (is != null) {
                AsterixConfiguration asterixConfiguration = this.configure(is, fileName);
                return asterixConfiguration;
            }
        }
        try {
            is = new FileInputStream(fileName);
            var3_4 = null;
            try {
                AsterixConfiguration asterixConfiguration = this.configure(is, fileName);
                return asterixConfiguration;
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var3_4 != null) {
                        try {
                            ((FileInputStream)is).close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)is).close();
                    }
                }
            }
        }
        catch (FileNotFoundException fnf1) {
            LOGGER.warn((Object)("Failed to get configuration file " + fileName + " as FileInputStream. FileNotFoundException"));
            LOGGER.warn((Object)"Attempting to get default configuration file asterix-configuration.xml as FileInputStream");
            try (FileInputStream fis = new FileInputStream("asterix-configuration.xml");){
                AsterixConfiguration asterixConfiguration = this.configure(fis, "asterix-configuration.xml");
                return asterixConfiguration;
            }
            catch (FileNotFoundException fnf2) {
                fnf1.addSuppressed(fnf2);
                throw new AsterixException("Could not find configuration file " + fileName, fnf1);
            }
        }
    }

    private AsterixConfiguration configure(InputStream is, String fileName) throws AsterixException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{AsterixConfiguration.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            return (AsterixConfiguration)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new AsterixException("Failed to read configuration file " + fileName, e);
        }
    }

    private void configureExtension(String className, String section) {
        Set keys = this.cfg.getKeys(section);
        ArrayList<Pair<String, String>> kvs = new ArrayList<Pair<String, String>>();
        for (String key : keys) {
            String value = this.cfg.getString(section, key);
            kvs.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        }
        this.extensions.add(new AsterixExtension(className, kvs));
    }

    private void configureNc(String ncId, MutableInt uniquePartitionId) {
        IApplicationConfig nodeCfg = this.cfg.getNCEffectiveConfig(ncId);
        this.coredumpConfig.put(ncId, nodeCfg.getString((IOption)NodeProperties.Option.CORE_DUMP_DIR));
        this.transactionLogDirs.put(ncId, nodeCfg.getString((IOption)NodeProperties.Option.TXN_LOG_DIR));
        String[] iodevices = nodeCfg.getStringArray((IOption)NCConfig.Option.IODEVICES);
        String storageSubdir = nodeCfg.getString((IOption)NodeProperties.Option.STORAGE_SUBDIR);
        String[] nodeStores = new String[iodevices.length];
        ClusterPartition[] nodePartitions = new ClusterPartition[iodevices.length];
        for (int i = 0; i < nodePartitions.length; ++i) {
            nodeStores[i] = iodevices[i] + File.separator + storageSubdir;
            ClusterPartition partition = new ClusterPartition(uniquePartitionId.getValue(), ncId, i);
            uniquePartitionId.increment();
            this.clusterPartitions.put(partition.getPartitionId(), partition);
            nodePartitions[i] = partition;
        }
        this.stores.put(ncId, nodeStores);
        this.nodePartitionsMap.put(ncId, nodePartitions);
    }

    private void loadAsterixBuildProperties() throws AsterixException {
        Properties gitProperties = new Properties();
        try {
            InputStream propertyStream = this.getClass().getClassLoader().getResourceAsStream("git.properties");
            if (propertyStream != null) {
                gitProperties.load(propertyStream);
                for (String name : gitProperties.stringPropertyNames()) {
                    this.asterixBuildProperties.put(name, gitProperties.getProperty(name));
                }
            } else {
                LOGGER.info((Object)"Build properties not found on classpath. Version API will return empty object");
            }
        }
        catch (IOException e) {
            throw new AsterixException(e);
        }
    }

    public Map<String, String[]> getStores() {
        return this.stores;
    }

    public String getCoredumpPath(String nodeId) {
        return this.coredumpConfig.get(nodeId);
    }

    public Map<String, String> getTransactionLogDirs() {
        return this.transactionLogDirs;
    }

    public Map<String, String> getCoredumpConfig() {
        return this.coredumpConfig;
    }

    public Map<String, String> getBuildProperties() {
        return this.asterixBuildProperties;
    }

    public <T> T getProperty(String property, T defaultValue, IOptionType<T> interpreter) {
        String value = this.cfg.getString("common", property);
        try {
            return (T)(value == null ? defaultValue : interpreter.parse(value));
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)("Invalid property value '" + value + "' for property '" + property + "'.\nDefault = " + defaultValue));
            }
            throw e;
        }
    }

    public Map<String, ClusterPartition[]> getNodePartitions() {
        return this.nodePartitionsMap;
    }

    public SortedMap<Integer, ClusterPartition> getClusterPartitions() {
        return this.clusterPartitions;
    }

    public List<AsterixExtension> getExtensions() {
        return this.extensions;
    }

    public static PropertiesAccessor getInstance(IApplicationConfig cfg) throws IOException, AsterixException {
        PropertiesAccessor accessor = instances.get(cfg);
        if (accessor == null && instances.putIfAbsent(cfg, accessor = new PropertiesAccessor(cfg)) != null) {
            return instances.get(cfg);
        }
        return accessor;
    }

    public Object getStatic(IOption option) {
        return this.cfg.getStatic(option);
    }

    public String getString(String section, String key) {
        return this.cfg.getString(section, key);
    }

    public int getInt(String section, String key) {
        return this.cfg.getInt(section, key);
    }

    public long getLong(String section, String key) {
        return this.cfg.getLong(section, key);
    }

    public Set<String> getSectionNames() {
        return this.cfg.getSectionNames();
    }

    public Set<String> getKeys(String section) {
        return this.cfg.getKeys(section);
    }

    public List<String> getNCNames() {
        return this.cfg.getNCNames();
    }

    public IOption lookupOption(String sectionName, String propertyName) {
        return this.cfg.lookupOption(sectionName, propertyName);
    }

    public IApplicationConfig getNCEffectiveConfig(String nodeId) {
        return this.cfg.getNCEffectiveConfig(nodeId);
    }

    public Set<IOption> getOptions() {
        return this.cfg.getOptions();
    }

    public Set<IOption> getOptions(Section section) {
        return this.cfg.getOptions(section);
    }

    public Set<Section> getSections() {
        return this.cfg.getSections();
    }

    public Set<Section> getSections(Predicate<Section> predicate) {
        return this.cfg.getSections(predicate);
    }
}

