/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.function.Supplier;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.file.FileUtil;

public class NodeProperties
extends AbstractProperties {
    public NodeProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public boolean isInitialRun() {
        return this.accessor.getBoolean(Option.INITIAL_RUN);
    }

    public boolean isVirtualNc() {
        return this.accessor.getBoolean((IOption)NCConfig.Option.VIRTUAL_NC);
    }

    public static enum Option implements IOption
    {
        INITIAL_RUN(OptionTypes.BOOLEAN, false, "A flag indicating if it's the first time the NC is started"),
        CORE_DUMP_DIR(OptionTypes.STRING, () -> FileUtil.joinPath((String[])new String[]{NCConfig.defaultDir, "coredump"}), "The directory where node core dumps should be written"),
        TXN_LOG_DIR(OptionTypes.STRING, () -> FileUtil.joinPath((String[])new String[]{NCConfig.defaultDir, "txn-log"}), "The directory where transaction logs should be stored"),
        STORAGE_SUBDIR(OptionTypes.STRING, "storage", "The subdirectory name under each iodevice used for storage");

        private final IOptionType type;
        private final Object defaultValue;
        private final String description;

        private <T> Option(IOptionType<T> type, T defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        private <T> Option(IOptionType<T> type, Supplier<T> defaultValue, String description) {
            this.type = type;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public Section section() {
            return Section.NC;
        }

        public String description() {
            return this.description;
        }

        public IOptionType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public boolean hidden() {
            return this == INITIAL_RUN;
        }
    }
}

