/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.service;

import java.io.File;
import java.util.List;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.event.service.ZooKeeperService;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ClusterStateWatcher
implements Watcher {
    private final Object mutex = new Object();
    private final ZooKeeper zk;
    private String clusterStatePath;
    private boolean done = false;
    private IClusterManagementWork.ClusterState clusterState = IClusterManagementWork.ClusterState.STARTING;
    private boolean failed = false;
    private Exception failureCause = null;
    private static Logger LOGGER = Logger.getLogger((String)ClusterStateWatcher.class.getName());

    public ClusterStateWatcher(ZooKeeper zk, String clusterName) {
        this.clusterStatePath = ZooKeeperService.ASTERIX_INSTANCE_BASE_PATH + File.separator + clusterName + ZooKeeperService.ASTERIX_INSTANCE_STATE_PATH;
        this.zk = zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClusterManagementWork.ClusterState waitForClusterStart() throws Exception {
        while (true) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.done) {
                    if (this.failed) {
                        LOGGER.error((Object)"An error took place in the startup sequence. Check the CC logs.");
                        throw this.failureCause;
                    }
                    return this.clusterState;
                }
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void monitorStateChange() {
        try {
            while (true) {
                Object object = this.mutex;
                synchronized (object) {
                    List list = this.zk.getChildren(this.clusterStatePath, (Watcher)this);
                    if (list.size() != 0) {
                        byte[] b = this.zk.getData(this.clusterStatePath + ZooKeeperService.ASTERIX_INSTANCE_STATE_REPORT, false, null);
                        this.zk.delete(this.clusterStatePath + ZooKeeperService.ASTERIX_INSTANCE_STATE_REPORT, 0);
                        this.clusterState = IClusterManagementWork.ClusterState.values()[b[0]];
                        this.done = true;
                        this.mutex.notifyAll();
                        return;
                    }
                    this.mutex.wait();
                }
            }
        }
        catch (Exception e) {
            this.failed = true;
            this.done = true;
            this.failureCause = e;
            return;
        }
    }

    public void startMonitoringThread() {
        Runnable monitoringThread = new Runnable(){

            @Override
            public void run() {
                ClusterStateWatcher.this.monitorStateChange();
            }
        };
        new Thread(monitoringThread).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(WatchedEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }
}

