package org.apache.archiva.redback.authentication;
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.archiva.redback.users.User;

import java.io.Serializable;

/**
 * detail on possible authentication failure.
 *
 * @author Olivier Lamy
 * @since 1.4-M4
 */
public class AuthenticationFailureCause
    implements Serializable
{
    private int cause;

    private String message;

    private User user;

    public AuthenticationFailureCause( int cause, String message )
    {
        this.cause = cause;
        this.message = message;
    }

    public int getCause()
    {
        return cause;
    }

    public void setCause( int cause )
    {
        this.cause = cause;
    }

    public String getMessage()
    {
        return message;
    }

    public void setMessage( String message )
    {
        this.message = message;
    }

    public User getUser()
    {
        return user;
    }

    public AuthenticationFailureCause user ( User user)
    {
        this.user = user;
        return this;
    }

    public void setUser( User user )
    {
        this.user = user;
    }

    @Override
    public String toString()
    {
        final StringBuilder sb = new StringBuilder();
        sb.append( "AuthenticationFailureCause" );
        sb.append( "{cause=" ).append( cause );
        sb.append( ", message='" ).append( message ).append( '\'' );
        sb.append( '}' );
        return sb.toString();
    }
}
