/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.scheduler;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.archiva.redback.components.scheduler.Scheduler;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduler
implements Scheduler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Properties properties;
    private StdScheduler scheduler;

    public void scheduleJob(JobDetailImpl jobDetail, Trigger trigger) throws SchedulerException {
        if (jobDetail == null || jobDetail.getName() == null) {
            throw new SchedulerException("No job or no job name - cannot schedule this job");
        }
        if (this.jobExists(jobDetail.getName(), jobDetail.getGroup())) {
            this.log.warn("Will not schedule this job as a job {" + jobDetail.getName() + ":" + jobDetail.getGroup() + "} already exists.");
            return;
        }
        try {
            this.scheduler.scheduleJob((JobDetail)jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new SchedulerException("Error scheduling job.", (Throwable)e);
        }
        catch (Exception e) {
            throw new SchedulerException("Error scheduling job (Verify your cron expression).", (Throwable)e);
        }
    }

    public void addGlobalJobListener(JobListener listener) throws SchedulerException {
        this.scheduler.getListenerManager().addJobListener(listener, new AllMatch());
    }

    public void addGlobalTriggerListener(TriggerListener listener) throws SchedulerException {
        this.scheduler.getListenerManager().addTriggerListener(listener, new AllMatch());
    }

    @PostConstruct
    public void initialize() throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory(this.properties);
        this.scheduler = (StdScheduler)factory.getScheduler();
        this.scheduler.start();
    }

    @PreDestroy
    public void stop() {
        this.scheduler.shutdown();
    }

    public void unscheduleJob(String jobName, String groupName) throws SchedulerException {
        if (jobName == null) {
            throw new SchedulerException("Job name null - cannot unschedule job");
        }
        try {
            if (this.jobExists(jobName, groupName)) {
                this.scheduler.deleteJob(new JobKey(jobName, groupName));
            }
        }
        catch (SchedulerException e) {
            throw new SchedulerException("Error unscheduling job.", (Throwable)e);
        }
    }

    public boolean interruptSchedule(String jobName, String groupName) throws SchedulerException {
        try {
            return this.scheduler.interrupt(new JobKey(jobName, groupName));
        }
        catch (Exception e) {
            throw new SchedulerException("Can't interrup job \"" + jobName + "\".", (Throwable)e);
        }
    }

    private boolean jobExists(String jobName, String jobGroup) throws SchedulerException {
        return this.scheduler.getJobDetail(new JobKey(jobName, jobGroup)) != null;
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.log.info("call shutdown waitForJobsToComplete : {}", (Object)waitForJobsToComplete);
        this.scheduler.shutdown(waitForJobsToComplete);
    }

    public StdScheduler getScheduler() {
        return this.scheduler;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllMatch<R extends Key<?>>
    implements Matcher<R> {
        private AllMatch() {
        }

        public boolean isMatch(R key) {
            return true;
        }
    }
}

