/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamException;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamState;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamResultFuture
extends AbstractFuture<StreamState> {
    private static final Logger logger = LoggerFactory.getLogger(StreamResultFuture.class);
    public final UUID planId;
    public final String description;
    private final Collection<StreamEventHandler> eventListeners = new ConcurrentLinkedQueue<StreamEventHandler>();
    private final Map<InetAddress, StreamSession> ongoingSessions;
    private final Map<InetAddress, SessionInfo> sessionStates = new NonBlockingHashMap();

    private StreamResultFuture(UUID planId, String description, Collection<StreamSession> sessions) {
        this.planId = planId;
        this.description = description;
        this.ongoingSessions = new HashMap<InetAddress, StreamSession>(sessions.size());
        for (StreamSession session : sessions) {
            this.ongoingSessions.put(session.peer, session);
        }
        if (sessions.isEmpty()) {
            this.set(this.getCurrentState());
        }
    }

    static StreamResultFuture init(UUID planId, String description, Collection<StreamSession> sessions) {
        StreamResultFuture future = StreamResultFuture.createAndRegister(planId, description, sessions);
        logger.info("[Stream #{}] Executing streaming plan for {}", (Object)planId, (Object)description);
        for (StreamSession session : sessions) {
            logger.info("[Stream #{}] Beginning stream session with {}", (Object)planId, (Object)session.peer);
            session.init(future);
            session.start();
        }
        return future;
    }

    public static synchronized StreamResultFuture initReceivingSide(UUID planId, String description, InetAddress from, Socket socket, boolean isForOutgoing, int version) throws IOException {
        StreamResultFuture future = StreamManager.instance.getReceivingStream(planId);
        if (future == null) {
            StreamSession session = new StreamSession(from);
            future = new StreamResultFuture(planId, description, Collections.singleton(session));
            StreamManager.instance.registerReceiving(future);
            session.init(future);
            session.handler.initiateOnReceivingSide(socket, isForOutgoing, version);
        } else {
            future.attachSocket(from, socket, isForOutgoing, version);
            logger.info("[Stream #{}] Received streaming plan for {}", (Object)planId, (Object)description);
        }
        return future;
    }

    private static StreamResultFuture createAndRegister(UUID planId, String description, Collection<StreamSession> sessions) {
        StreamResultFuture future = new StreamResultFuture(planId, description, sessions);
        StreamManager.instance.register(future);
        return future;
    }

    public void attachSocket(InetAddress from, Socket socket, boolean isForOutgoing, int version) throws IOException {
        StreamSession session = this.ongoingSessions.get(from);
        if (session == null) {
            throw new RuntimeException(String.format("Got connection from %s for stream session %s but no such session locally", from, this.planId));
        }
        session.handler.initiateOnReceivingSide(socket, isForOutgoing, version);
    }

    public void addEventListener(StreamEventHandler listener) {
        Futures.addCallback((ListenableFuture)this, (FutureCallback)listener);
        this.eventListeners.add(listener);
    }

    public StreamState getCurrentState() {
        return new StreamState(this.planId, this.description, (Set<SessionInfo>)ImmutableSet.copyOf(this.sessionStates.values()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StreamResultFuture that = (StreamResultFuture)((Object)o);
        return this.planId.equals(that.planId);
    }

    public int hashCode() {
        return this.planId.hashCode();
    }

    void handleSessionPrepared(StreamSession session) {
        SessionInfo sessionInfo = session.getSessionInfo();
        logger.info("[Stream #{}] Prepare completed. Receiving {} files({} bytes), sending {} files({} bytes)", new Object[]{session.planId(), sessionInfo.getTotalFilesToReceive(), sessionInfo.getTotalSizeToReceive(), sessionInfo.getTotalFilesToSend(), sessionInfo.getTotalSizeToSend()});
        StreamEvent.SessionPreparedEvent event = new StreamEvent.SessionPreparedEvent(this.planId, sessionInfo);
        this.sessionStates.put(sessionInfo.peer, sessionInfo);
        this.fireStreamEvent(event);
    }

    void handleSessionComplete(StreamSession session) {
        logger.info("[Stream #{}] Session with {} is complete", (Object)session.planId(), (Object)session.peer);
        SessionInfo sessionInfo = session.getSessionInfo();
        this.sessionStates.put(sessionInfo.peer, sessionInfo);
        this.fireStreamEvent(new StreamEvent.SessionCompleteEvent(session));
        this.maybeComplete(session);
    }

    public void handleProgress(ProgressInfo progress) {
        this.sessionStates.get(progress.peer).updateProgress(progress);
        this.fireStreamEvent(new StreamEvent.ProgressEvent(this.planId, progress));
    }

    void fireStreamEvent(StreamEvent event) {
        for (StreamEventHandler listener : this.eventListeners) {
            listener.handleStreamEvent(event);
        }
    }

    private synchronized void maybeComplete(StreamSession session) {
        this.ongoingSessions.remove(session.peer);
        if (this.ongoingSessions.isEmpty()) {
            StreamState finalState = this.getCurrentState();
            if (finalState.hasFailedSession()) {
                logger.warn("[Stream #{}] Stream failed", (Object)this.planId);
                this.setException(new StreamException(finalState, "Stream failed"));
            } else {
                logger.info("[Stream #{}] All sessions completed", (Object)this.planId);
                this.set(finalState);
            }
        }
    }
}

