package org.apache.archiva.rest.api.model;
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

/**
 * @author Olivier Lamy
 */
@XmlRootElement( name = "versionsList" )
public class VersionsList
    implements Serializable
{

    private List<String> versions;

    public VersionsList()
    {
        // no op
    }

    public VersionsList( List<String> versions )
    {
        this.versions = versions;
    }

    public List<String> getVersions()
    {
        return versions;
    }

    public void setVersions( List<String> versions )
    {
        this.versions = versions;
    }

    @Override
    public String toString()
    {
        final StringBuilder sb = new StringBuilder();
        sb.append( "VersionsList" );
        sb.append( "{versions=" ).append( versions );
        sb.append( '}' );
        return sb.toString();
    }
}
