/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.util.IoUtils;

public abstract class StreamWagon
extends AbstractWagon {
    public abstract void fillInputData(InputData var1) throws TransferFailedException, ResourceDoesNotExistException;

    public abstract void fillOutputData(OutputData var1) throws TransferFailedException;

    public abstract void openConnection() throws ConnectionException, AuthenticationException;

    public abstract void closeConnection() throws ConnectionException;

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputData inputData = new InputData();
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        inputData.setResource(resource);
        this.fillInputData(inputData);
        InputStream is = inputData.getInputStream();
        if (is == null) {
            throw new TransferFailedException(this.getRepository().getUrl() + " - Could not open input stream for resource: '" + resource + "'");
        }
        this.createParentDirectories(destination);
        this.getTransfer(inputData.getResource(), destination, is);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        boolean retValue = false;
        InputData inputData = new InputData();
        Resource resource = new Resource(resourceName);
        inputData.setResource(resource);
        this.fillInputData(inputData);
        InputStream is = inputData.getInputStream();
        if (resource.getLastModified() > timestamp) {
            retValue = true;
            if (is == null) {
                throw new TransferFailedException(this.getRepository().getUrl() + " - Could not open input stream for resource: '" + resource + "'");
            }
            this.createParentDirectories(destination);
            this.getTransfer(inputData.getResource(), destination, is);
        } else {
            IoUtils.close(is);
        }
        return retValue;
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        OutputData outputData = new OutputData();
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        outputData.setResource(resource);
        this.fillOutputData(outputData);
        OutputStream os = outputData.getOutputStream();
        if (os == null) {
            throw new TransferFailedException(this.getRepository().getUrl() + " - Could not open output stream for resource: '" + resource + "'");
        }
        this.putTransfer(outputData.getResource(), source, os, true);
    }
}

