/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.EnumSet;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeliveryTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MessageDeliveryTask.class);
    private final MessageIn message;
    private final long constructionTime;
    private final int id;
    EnumSet<MessagingService.Verb> GOSSIP_VERBS = EnumSet.of(MessagingService.Verb.GOSSIP_DIGEST_ACK, MessagingService.Verb.GOSSIP_DIGEST_ACK2, MessagingService.Verb.GOSSIP_DIGEST_SYN);

    public MessageDeliveryTask(MessageIn message, int id, long timestamp) {
        assert (message != null);
        this.message = message;
        this.id = id;
        this.constructionTime = timestamp;
    }

    @Override
    public void run() {
        MessagingService.Verb verb = this.message.verb;
        if (MessagingService.DROPPABLE_VERBS.contains((Object)verb) && System.currentTimeMillis() > this.constructionTime + this.message.getTimeout()) {
            MessagingService.instance().incrementDroppedMessages(verb);
            return;
        }
        IVerbHandler verbHandler = MessagingService.instance().getVerbHandler(verb);
        if (verbHandler == null) {
            logger.debug("Unknown verb {}", (Object)verb);
            return;
        }
        verbHandler.doVerb(this.message, this.id);
        if (this.GOSSIP_VERBS.contains((Object)this.message.verb)) {
            Gossiper.instance.setLastProcessedMessageAt(this.constructionTime);
        }
    }
}

