/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.Progressable;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BulkRecordWriter
extends RecordWriter<ByteBuffer, List<Mutation>>
implements org.apache.hadoop.mapred.RecordWriter<ByteBuffer, List<Mutation>> {
    private static final String OUTPUT_LOCATION = "mapreduce.output.bulkoutputformat.localdir";
    private static final String BUFFER_SIZE_IN_MB = "mapreduce.output.bulkoutputformat.buffersize";
    private static final String STREAM_THROTTLE_MBITS = "mapreduce.output.bulkoutputformat.streamthrottlembits";
    private static final String MAX_FAILED_HOSTS = "mapreduce.output.bulkoutputformat.maxfailedhosts";
    private final Configuration conf;
    private final Logger logger = LoggerFactory.getLogger(BulkRecordWriter.class);
    private SSTableSimpleUnsortedWriter writer;
    private SSTableLoader loader;
    private File outputdir;
    private Progressable progress;
    private int maxFailures;
    private CFType cfType;
    private ColType colType;

    BulkRecordWriter(TaskAttemptContext context) {
        this(context.getConfiguration());
        this.progress = new Progressable(context);
    }

    BulkRecordWriter(Configuration conf, Progressable progress) {
        this(conf);
        this.progress = progress;
    }

    BulkRecordWriter(Configuration conf) {
        Config.setClientMode(true);
        Config.setOutboundBindAny(true);
        this.conf = conf;
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(Integer.parseInt(conf.get(STREAM_THROTTLE_MBITS, "0")));
        this.maxFailures = Integer.parseInt(conf.get(MAX_FAILED_HOSTS, "0"));
    }

    private String getOutputLocation() throws IOException {
        String dir = this.conf.get(OUTPUT_LOCATION, System.getProperty("java.io.tmpdir"));
        if (dir == null) {
            throw new IOException("Output directory not defined, if hadoop is not setting java.io.tmpdir then define mapreduce.output.bulkoutputformat.localdir");
        }
        return dir;
    }

    private void setTypes(Mutation mutation) {
        if (this.cfType == null) {
            this.cfType = mutation.getColumn_or_supercolumn().isSetSuper_column() || mutation.getColumn_or_supercolumn().isSetCounter_super_column() ? CFType.SUPER : CFType.NORMAL;
            this.colType = mutation.getColumn_or_supercolumn().isSetCounter_column() || mutation.getColumn_or_supercolumn().isSetCounter_super_column() ? ColType.COUNTER : ColType.NORMAL;
        }
    }

    private void prepareWriter() throws IOException {
        if (this.outputdir == null) {
            String keyspace = ConfigHelper.getOutputKeyspace(this.conf);
            this.outputdir = new File(this.getOutputLocation() + File.separator + keyspace + File.separator + ConfigHelper.getOutputColumnFamily(this.conf));
            this.outputdir.mkdirs();
        }
        if (this.writer == null) {
            BytesType subcomparator = null;
            ExternalClient externalClient = null;
            String username = ConfigHelper.getOutputKeyspaceUserName(this.conf);
            String password = ConfigHelper.getOutputKeyspacePassword(this.conf);
            if (this.cfType == CFType.SUPER) {
                subcomparator = BytesType.instance;
            }
            this.writer = new SSTableSimpleUnsortedWriter(this.outputdir, ConfigHelper.getOutputPartitioner(this.conf), ConfigHelper.getOutputKeyspace(this.conf), ConfigHelper.getOutputColumnFamily(this.conf), BytesType.instance, subcomparator, Integer.parseInt(this.conf.get(BUFFER_SIZE_IN_MB, "64")), ConfigHelper.getOutputCompressionParamaters(this.conf));
            externalClient = new ExternalClient(ConfigHelper.getOutputInitialAddress(this.conf), ConfigHelper.getOutputRpcPort(this.conf), username, password);
            this.loader = new SSTableLoader(this.outputdir, externalClient, new NullOutputHandler());
        }
    }

    public void write(ByteBuffer keybuff, List<Mutation> value) throws IOException {
        this.setTypes(value.get(0));
        this.prepareWriter();
        this.writer.newRow(keybuff);
        for (Mutation mut : value) {
            if (this.cfType == CFType.SUPER) {
                this.writer.newSuperColumn(mut.getColumn_or_supercolumn().getSuper_column().name);
                if (this.colType == ColType.COUNTER) {
                    for (CounterColumn column : mut.getColumn_or_supercolumn().getCounter_super_column().columns) {
                        this.writer.addCounterColumn(column.name, column.value);
                    }
                } else {
                    for (CounterColumn column : mut.getColumn_or_supercolumn().getSuper_column().columns) {
                        if (column.ttl == 0) {
                            this.writer.addColumn(column.name, column.value, column.timestamp);
                            continue;
                        }
                        this.writer.addExpiringColumn(column.name, column.value, column.timestamp, column.ttl, System.currentTimeMillis() + (long)column.ttl * 1000L);
                    }
                }
            } else if (this.colType == ColType.COUNTER) {
                this.writer.addCounterColumn(mut.getColumn_or_supercolumn().counter_column.name, mut.getColumn_or_supercolumn().counter_column.value);
            } else if (mut.getColumn_or_supercolumn().column.ttl == 0) {
                this.writer.addColumn(mut.getColumn_or_supercolumn().column.name, mut.getColumn_or_supercolumn().column.value, mut.getColumn_or_supercolumn().column.timestamp);
            } else {
                this.writer.addExpiringColumn(mut.getColumn_or_supercolumn().column.name, mut.getColumn_or_supercolumn().column.value, mut.getColumn_or_supercolumn().column.timestamp, mut.getColumn_or_supercolumn().column.ttl, System.currentTimeMillis() + (long)mut.getColumn_or_supercolumn().column.ttl * 1000L);
            }
            this.progress.progress();
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.close();
    }

    @Deprecated
    public void close(Reporter reporter) throws IOException {
        this.close();
    }

    private void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            StreamResultFuture future = this.loader.stream();
            while (true) {
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException te) {
                    this.progress.progress();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                break;
            }
            if (this.loader.getFailedHosts().size() > 0) {
                if (this.loader.getFailedHosts().size() > this.maxFailures) {
                    throw new IOException("Too many hosts failed: " + this.loader.getFailedHosts());
                }
                this.logger.warn("Some hosts failed: " + this.loader.getFailedHosts());
            }
        }
    }

    static class NullOutputHandler
    implements OutputHandler {
        NullOutputHandler() {
        }

        @Override
        public void output(String msg) {
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void warn(String msg) {
        }

        @Override
        public void warn(String msg, Throwable th) {
        }
    }

    static class ExternalClient
    extends SSTableLoader.Client {
        private final Map<String, Map<String, CFMetaData>> knownCfs = new HashMap<String, Map<String, CFMetaData>>();
        private final String hostlist;
        private final int rpcPort;
        private final String username;
        private final String password;

        public ExternalClient(String hostlist, int port, String username, String password) {
            this.hostlist = hostlist;
            this.rpcPort = port;
            this.username = username;
            this.password = password;
        }

        @Override
        public void init(String keyspace) {
            String[] nodes;
            HashSet<InetAddress> hosts = new HashSet<InetAddress>();
            for (String node : nodes = this.hostlist.split(",")) {
                try {
                    hosts.add(InetAddress.getByName(node));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            Iterator hostiter = hosts.iterator();
            while (hostiter.hasNext()) {
                try {
                    InetAddress host = (InetAddress)hostiter.next();
                    Cassandra.Client client = ExternalClient.createThriftClient(host.getHostAddress(), this.rpcPort);
                    client.set_keyspace(keyspace);
                    if (this.username != null) {
                        HashMap<String, String> creds = new HashMap<String, String>();
                        creds.put("username", this.username);
                        creds.put("password", this.password);
                        AuthenticationRequest authRequest = new AuthenticationRequest(creds);
                        client.login(authRequest);
                    }
                    List tokenRanges = client.describe_ring(keyspace);
                    List ksDefs = client.describe_keyspaces();
                    this.setPartitioner(client.describe_partitioner());
                    Token.TokenFactory tkFactory = this.getPartitioner().getTokenFactory();
                    for (TokenRange tr : tokenRanges) {
                        Range<Token> range = new Range<Token>(tkFactory.fromString(tr.start_token), tkFactory.fromString(tr.end_token));
                        for (String ep : tr.endpoints) {
                            this.addRangeForEndpoint(range, InetAddress.getByName(ep));
                        }
                    }
                    for (KsDef ksDef : ksDefs) {
                        HashMap<String, CFMetaData> cfs = new HashMap<String, CFMetaData>(ksDef.cf_defs.size());
                        for (CfDef cfDef : ksDef.cf_defs) {
                            cfs.put(cfDef.name, CFMetaData.fromThrift(cfDef));
                        }
                        this.knownCfs.put(ksDef.name, cfs);
                    }
                    break;
                }
                catch (Exception e) {
                    if (hostiter.hasNext()) continue;
                    throw new RuntimeException("Could not retrieve endpoint ranges: ", e);
                }
            }
        }

        @Override
        public CFMetaData getCFMetaData(String keyspace, String cfName) {
            Map<String, CFMetaData> cfs = this.knownCfs.get(keyspace);
            return cfs != null ? cfs.get(cfName) : null;
        }

        private static Cassandra.Client createThriftClient(String host, int port) throws TTransportException {
            TSocket socket = new TSocket(host, port);
            TFramedTransport trans = new TFramedTransport((TTransport)socket);
            trans.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)trans);
            return new Cassandra.Client((TProtocol)protocol);
        }
    }

    private static enum ColType {
        NORMAL,
        COUNTER;

    }

    private static enum CFType {
        NORMAL,
        SUPER;

    }
}

