/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="listRepositories", description="Displays a list of all defined repositories.")
public class ListRepositoriesCommand
extends FeaturesCommandSupport {
    private static final String REPOSITORY = "Repository";
    private static final String REPOSITORY_URL = "Repository URL";
    @Option(name="-u", description="Display repository URLs.", required=false, multiValued=false)
    boolean showUrl;

    protected void doExecute(FeaturesService admin) throws Exception {
        StringBuffer sb = null;
        Repository[] repos = admin.listRepositories();
        int maxRepositorySize = REPOSITORY.length();
        int maxRepositoryUrlSize = REPOSITORY_URL.length();
        for (Repository r : repos) {
            maxRepositorySize = Math.max(maxRepositorySize, r.getName().length());
            maxRepositoryUrlSize = Math.max(maxRepositoryUrlSize, r.getURI().toString().length());
        }
        if (repos != null && repos.length > 0) {
            sb = new StringBuffer();
            this.append(sb, REPOSITORY, maxRepositorySize + 2);
            if (this.showUrl) {
                this.append(sb, REPOSITORY_URL, maxRepositoryUrlSize + 2);
            }
            System.out.println(sb.toString());
            for (int i = 0; i < repos.length; ++i) {
                sb = new StringBuffer();
                this.append(sb, repos[i].getName(), maxRepositorySize + 2);
                if (this.showUrl) {
                    this.append(sb, repos[i].getURI().toString(), maxRepositoryUrlSize + 2);
                }
                System.out.println(sb.toString());
            }
        } else {
            System.out.println("No repositories available.");
        }
    }

    private void append(StringBuffer sb, String s, int width) {
        sb.append(s);
        for (int i = s.length(); i < width; ++i) {
            sb.append(" ");
        }
    }
}

