package org.apache.archiva.rss;

import java.util.Date;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Holds the data for the SyndEntry in the RSS feed.
 * 
 * @version
 */
public class RssFeedEntry
{
    private String title;
    
    private String link;
    
    private String description;
    
    private String author;
    
    private String category;
    
    private String comments;
    
    private String enclosure;
    
    private String guid;
    
    private String source;
    
    private Date publishedDate;
    
    public RssFeedEntry()
    {
        
    }
    
    public RssFeedEntry( String title )
    {
        this.title = title;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle( String title )
    {
        this.title = title;
    }

    public String getLink()
    {
        return link;
    }

    public void setLink( String link )
    {
        this.link = link;
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription( String description )
    {
        this.description = description;
    }

    public String getAuthor()
    {
        return author;
    }

    public void setAuthor( String author )
    {
        this.author = author;
    }

    public String getCategory()
    {
        return category;
    }

    public void setCategory( String category )
    {
        this.category = category;
    }

    public String getComments()
    {
        return comments;
    }

    public void setComments( String comments )
    {
        this.comments = comments;
    }

    public String getEnclosure()
    {
        return enclosure;
    }

    public void setEnclosure( String enclosure )
    {
        this.enclosure = enclosure;
    }

    public String getGuid()
    {
        return guid;
    }

    public void setGuid( String guid )
    {
        this.guid = guid;
    }

    public String getSource()
    {
        return source;
    }

    public void setSource( String source )
    {
        this.source = source;
    }

    public Date getPublishedDate()
    {
        return publishedDate;
    }

    public void setPublishedDate( Date publishedDate )
    {
        this.publishedDate = publishedDate;
    }
}
