/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.version;

import java.io.Serializable;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;

public class VersionRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Version INFINITE_VERSION = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, "");
    public static final VersionRange ANY_VERSION = new VersionRange(false, Version.emptyVersion, INFINITE_VERSION, true);
    public static final int EXACT = 0;
    public static final int MICRO = 1;
    public static final int MINOR = 2;
    public static final int MAJOR = 3;
    public static final int ANY = 40;
    private final boolean openFloor;
    private final Version floor;
    private final Version ceiling;
    private final boolean openCeiling;

    public VersionRange(boolean openFloor, Version floor, Version ceiling, boolean openCeiling) {
        this.openFloor = openFloor;
        this.floor = floor;
        this.ceiling = ceiling;
        this.openCeiling = openCeiling;
        this.checkRange();
    }

    public VersionRange(Version atLeast) {
        this(atLeast, false);
    }

    public VersionRange(Version atLeast, boolean exact) {
        this.openFloor = false;
        this.floor = atLeast;
        this.ceiling = exact ? atLeast : INFINITE_VERSION;
        this.openCeiling = !exact;
        this.checkRange();
    }

    public VersionRange(String val) throws IllegalArgumentException, NumberFormatException {
        this(val, false);
    }

    public VersionRange(String val, boolean exact) throws IllegalArgumentException, NumberFormatException {
        this(val, exact, true);
    }

    public VersionRange(String val, boolean exact, boolean clean) throws IllegalArgumentException, NumberFormatException {
        val = val.replaceAll("\\s", "");
        val = val.replaceAll("\"", "");
        char fst = val.charAt(0);
        if (fst == '[') {
            this.openFloor = false;
        } else if (fst == '(') {
            this.openFloor = true;
        } else {
            this.openFloor = false;
            this.floor = VersionTable.getVersion(val, clean);
            this.ceiling = exact ? this.floor : INFINITE_VERSION;
            this.openCeiling = !exact;
            return;
        }
        char lst = val.charAt(val.length() - 1);
        if (lst == ']') {
            this.openCeiling = false;
        } else if (lst == ')') {
            this.openCeiling = true;
        } else {
            throw new IllegalArgumentException("illegal version range syntax " + val + ": range must end in ')' or ']'");
        }
        String inner = val.substring(1, val.length() - 1);
        String[] floorCeiling = inner.split(",");
        if (floorCeiling.length != 2) {
            throw new IllegalArgumentException("illegal version range syntax too many commas");
        }
        this.floor = VersionTable.getVersion(floorCeiling[0], clean);
        this.ceiling = "*".equals(floorCeiling[1]) ? INFINITE_VERSION : VersionTable.getVersion(floorCeiling[1], clean);
        this.checkRange();
    }

    public static VersionRange parseVersionRange(String val) throws IllegalArgumentException, NumberFormatException {
        if (val == null || val.trim().length() == 0) {
            return ANY_VERSION;
        }
        return new VersionRange(val);
    }

    public Version getCeiling() {
        return this.ceiling;
    }

    public Version getFloor() {
        return this.floor;
    }

    public boolean isOpenCeiling() {
        return this.openCeiling;
    }

    public boolean isOpenFloor() {
        return this.openFloor;
    }

    public boolean isPointVersion() {
        return !this.openFloor && !this.openCeiling && this.floor.equals((Object)this.ceiling);
    }

    public boolean contains(Version version) {
        if (version.equals((Object)INFINITE_VERSION)) {
            return this.ceiling.equals((Object)INFINITE_VERSION);
        }
        return version.compareTo((Object)this.floor) > 0 && version.compareTo((Object)this.ceiling) < 0 || !this.openFloor && version.equals((Object)this.floor) || !this.openCeiling && version.equals((Object)this.ceiling);
    }

    public VersionRange intersect(VersionRange r) {
        boolean newOpenCeiling;
        Version newCeiling;
        boolean newOpenFloor;
        Version newFloor;
        int minCompare = this.floor.compareTo((Object)r.getFloor());
        if (minCompare > 0) {
            newFloor = this.floor;
            newOpenFloor = this.openFloor;
        } else if (minCompare < 0) {
            newFloor = r.getFloor();
            newOpenFloor = r.isOpenFloor();
        } else {
            newFloor = this.floor;
            newOpenFloor = this.openFloor || r.isOpenFloor();
        }
        int maxCompare = this.ceiling.compareTo((Object)r.getCeiling());
        if (maxCompare < 0) {
            newCeiling = this.ceiling;
            newOpenCeiling = this.openCeiling;
        } else if (maxCompare > 0) {
            newCeiling = r.getCeiling();
            newOpenCeiling = r.isOpenCeiling();
        } else {
            newCeiling = this.ceiling;
            newOpenCeiling = this.openCeiling || r.isOpenCeiling();
        }
        VersionRange result = VersionRange.isRangeValid(newOpenFloor, newFloor, newCeiling, newOpenCeiling) ? new VersionRange(newOpenFloor, newFloor, newCeiling, newOpenCeiling) : null;
        return result;
    }

    private static boolean isRangeValid(boolean openFloor, Version floor, Version ceiling, boolean openCeiling) {
        int compare = floor.compareTo((Object)ceiling);
        boolean result = compare > 0 ? false : compare != 0 || !openFloor && !openCeiling;
        return result;
    }

    private void checkRange() {
        if (!VersionRange.isRangeValid(this.openFloor, this.floor, this.ceiling, this.openCeiling)) {
            throw new IllegalArgumentException("invalid version range: " + this.makeString(this.openFloor, this.floor, this.ceiling, this.openCeiling));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ceiling == null ? 0 : this.ceiling.hashCode());
        result = 31 * result + (this.floor == null ? 0 : this.floor.hashCode());
        result = 31 * result + (this.openCeiling ? 1231 : 1237);
        result = 31 * result + (this.openFloor ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        if (this.ceiling == null ? other.ceiling != null : !this.ceiling.equals((Object)other.ceiling)) {
            return false;
        }
        if (this.floor == null ? other.floor != null : !this.floor.equals((Object)other.floor)) {
            return false;
        }
        if (this.openCeiling != other.openCeiling) {
            return false;
        }
        return this.openFloor == other.openFloor;
    }

    public String toString() {
        if (ANY_VERSION.equals(this)) {
            return this.makeString(this.openFloor, Version.emptyVersion, INFINITE_VERSION, this.openCeiling);
        }
        return this.makeString(this.openFloor, this.floor, this.ceiling, this.openCeiling);
    }

    private String makeString(boolean openFloor, Version floor, Version ceiling, boolean openCeiling) {
        StringBuffer vr = new StringBuffer(32);
        if (INFINITE_VERSION.equals((Object)ceiling)) {
            vr.append(Version.emptyVersion.equals((Object)floor) ? "0" : floor.toString());
        } else {
            vr.append(openFloor ? "(" : "[");
            String floorStr = Version.emptyVersion.equals((Object)floor) ? "0" : floor.toString();
            String ceilingStr = ceiling.toString();
            vr.append(floorStr).append(",").append(ceilingStr);
            vr.append(openCeiling ? ")" : "]");
        }
        return vr.toString();
    }

    public static VersionRange newInstance(Version pointVersion, int lowerBoundRule, int upperBoundRule) {
        Version floor = null;
        switch (lowerBoundRule) {
            case 40: {
                floor = VersionTable.getVersion(0, 0, 0);
                break;
            }
            case 3: {
                floor = VersionTable.getVersion(pointVersion.getMajor(), 0, 0);
                break;
            }
            case 2: {
                floor = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor(), 0);
                break;
            }
            case 1: {
                floor = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor(), pointVersion.getMicro());
                break;
            }
            case 0: {
                floor = pointVersion;
            }
        }
        Version ceiling = null;
        boolean openCeiling = true;
        switch (upperBoundRule) {
            case 40: {
                ceiling = INFINITE_VERSION;
                break;
            }
            case 3: {
                ceiling = VersionTable.getVersion(pointVersion.getMajor() + 1, 0, 0);
                break;
            }
            case 2: {
                ceiling = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor() + 1, 0);
                break;
            }
            case 1: {
                ceiling = VersionTable.getVersion(pointVersion.getMajor(), pointVersion.getMinor(), pointVersion.getMicro() + 1);
                break;
            }
            case 0: {
                ceiling = pointVersion;
                openCeiling = false;
            }
        }
        return new VersionRange(false, floor, ceiling, openCeiling);
    }
}

