/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.scheduler;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.stereotype.Service;

@Service
public final class CronExpressionValidator {
    public boolean validate(String cronExpression) {
        try {
            String[] cronParams = StringUtils.split((String)cronExpression);
            if (cronParams.length < 6 || cronParams.length > 7) {
                return false;
            }
            CronTriggerImpl cronTrigger = new CronTriggerImpl();
            cronTrigger.setCronExpression(cronExpression);
            if (cronParams[3].equals("?") || cronParams[5].equals("?")) {
                if (!this.checkSecondsField(cronParams[0])) {
                    return false;
                }
                if (!this.checkMinutesField(cronParams[1])) {
                    return false;
                }
                if (!this.checkHoursField(cronParams[2])) {
                    return false;
                }
                if (!this.checkDayOfMonthField(cronParams[3])) {
                    return false;
                }
                if (!this.checkMonthsField(cronParams[4])) {
                    return false;
                }
                if (!this.checkDayOfWeekField(cronParams[5])) {
                    return false;
                }
                return cronParams.length != 7 || this.checkYearField(cronParams[6]);
            }
            return false;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private boolean checkSecondsField(String secondsField) {
        return this.checkField(secondsField, 0, 59);
    }

    private boolean checkMinutesField(String minutesField) {
        return this.checkField(minutesField, 0, 59);
    }

    private boolean checkHoursField(String hoursField) {
        return this.checkField(hoursField, 0, 23);
    }

    private boolean checkDayOfMonthField(String dayOfMonthField) {
        if ("?".equals(dayOfMonthField)) {
            return true;
        }
        if (dayOfMonthField.indexOf("L") >= 0) {
            return this.checkFieldWithLetter(dayOfMonthField, "L", 1, 7, -1, -1);
        }
        if (dayOfMonthField.indexOf("W") >= 0) {
            return this.checkFieldWithLetter(dayOfMonthField, "W", 1, 31, -1, -1);
        }
        if (dayOfMonthField.indexOf("C") >= 0) {
            return this.checkFieldWithLetter(dayOfMonthField, "C", 1, 31, -1, -1);
        }
        return this.checkField(dayOfMonthField, 1, 31);
    }

    private boolean checkMonthsField(String monthsField) {
        monthsField = StringUtils.replace((String)monthsField, (String)"JAN", (String)"1");
        monthsField = StringUtils.replace((String)monthsField, (String)"FEB", (String)"2");
        monthsField = StringUtils.replace((String)monthsField, (String)"MAR", (String)"3");
        monthsField = StringUtils.replace((String)monthsField, (String)"APR", (String)"4");
        monthsField = StringUtils.replace((String)monthsField, (String)"MAY", (String)"5");
        monthsField = StringUtils.replace((String)monthsField, (String)"JUN", (String)"6");
        monthsField = StringUtils.replace((String)monthsField, (String)"JUL", (String)"7");
        monthsField = StringUtils.replace((String)monthsField, (String)"AUG", (String)"8");
        monthsField = StringUtils.replace((String)monthsField, (String)"SEP", (String)"9");
        monthsField = StringUtils.replace((String)monthsField, (String)"OCT", (String)"10");
        monthsField = StringUtils.replace((String)monthsField, (String)"NOV", (String)"11");
        monthsField = StringUtils.replace((String)monthsField, (String)"DEC", (String)"12");
        return this.checkField(monthsField, 1, 31);
    }

    private boolean checkDayOfWeekField(String dayOfWeekField) {
        dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"SUN", (String)"1");
        dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"MON", (String)"2");
        dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"TUE", (String)"3");
        dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"WED", (String)"4");
        dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"THU", (String)"5");
        dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"FRI", (String)"6");
        if ("?".equals(dayOfWeekField = StringUtils.replace((String)dayOfWeekField, (String)"SAT", (String)"7"))) {
            return true;
        }
        if (dayOfWeekField.indexOf("L") >= 0) {
            return this.checkFieldWithLetter(dayOfWeekField, "L", 1, 7, -1, -1);
        }
        if (dayOfWeekField.indexOf("C") >= 0) {
            return this.checkFieldWithLetter(dayOfWeekField, "C", 1, 7, -1, -1);
        }
        if (dayOfWeekField.indexOf("#") >= 0) {
            return this.checkFieldWithLetter(dayOfWeekField, "#", 1, 7, 1, 5);
        }
        return this.checkField(dayOfWeekField, 1, 7);
    }

    private boolean checkYearField(String yearField) {
        return this.checkField(yearField, 1970, 2099);
    }

    private boolean checkField(String secondsField, int minimal, int maximal) {
        if (secondsField.indexOf("-") > -1) {
            String startValue = secondsField.substring(0, secondsField.indexOf("-"));
            String endValue = secondsField.substring(secondsField.indexOf("-") + 1);
            if (!this.checkIntValue(startValue, minimal, maximal) || !this.checkIntValue(endValue, minimal, maximal)) {
                return false;
            }
            try {
                int startVal = Integer.parseInt(startValue);
                int endVal = Integer.parseInt(endValue);
                return endVal > startVal;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (secondsField.indexOf(",") > -1) {
            return this.checkListField(secondsField, minimal, maximal);
        }
        if (secondsField.indexOf("/") > -1) {
            return this.checkIncrementField(secondsField, minimal, maximal);
        }
        if (secondsField.indexOf("*") != -1) {
            return true;
        }
        return this.checkIntValue(secondsField, minimal, maximal);
    }

    private boolean checkFieldWithLetter(String value, String letter, int minimalBefore, int maximalBefore, int minimalAfter, int maximalAfter) {
        boolean canBeAlone = false;
        boolean canHaveIntBefore = false;
        boolean canHaveIntAfter = false;
        boolean mustHaveIntBefore = false;
        boolean mustHaveIntAfter = false;
        if ("L".equals(letter)) {
            canBeAlone = true;
            canHaveIntBefore = true;
            canHaveIntAfter = false;
            mustHaveIntBefore = false;
            mustHaveIntAfter = false;
        }
        if ("W".equals(letter) || "C".equals(letter)) {
            canBeAlone = false;
            canHaveIntBefore = true;
            canHaveIntAfter = false;
            mustHaveIntBefore = true;
            mustHaveIntAfter = false;
        }
        if ("#".equals(letter)) {
            canBeAlone = false;
            canHaveIntBefore = true;
            canHaveIntAfter = true;
            mustHaveIntBefore = true;
            mustHaveIntAfter = true;
        }
        String beforeLetter = "";
        String afterLetter = "";
        if (value.indexOf(letter) >= 0) {
            beforeLetter = value.substring(0, value.indexOf(letter));
        }
        if (!value.endsWith(letter)) {
            afterLetter = value.substring(value.indexOf(letter) + 1);
        }
        if (value.indexOf(letter) >= 0) {
            if (letter.equals(value)) {
                return canBeAlone;
            }
            if (canHaveIntBefore) {
                if (mustHaveIntBefore && beforeLetter.length() == 0) {
                    return false;
                }
                if (!CronExpressionValidator.checkIntValue(beforeLetter, minimalBefore, maximalBefore, true)) {
                    return false;
                }
            } else if (beforeLetter.length() > 0) {
                return false;
            }
            if (canHaveIntAfter) {
                if (mustHaveIntAfter && afterLetter.length() == 0) {
                    return false;
                }
                if (!CronExpressionValidator.checkIntValue(afterLetter, minimalAfter, maximalAfter, true)) {
                    return false;
                }
            } else if (afterLetter.length() > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkIncrementField(String value, int minimal, int maximal) {
        String start = value.substring(0, value.indexOf("/"));
        String increment = value.substring(value.indexOf("/") + 1);
        if (!"*".equals(start)) {
            return this.checkIntValue(start, minimal, maximal) && CronExpressionValidator.checkIntValue(increment, minimal, maximal, false);
        }
        return this.checkIntValue(increment, minimal, maximal);
    }

    private boolean checkListField(String value, int minimal, int maximal) {
        StringTokenizer st = new StringTokenizer(value, ",");
        ArrayList<String> values = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            values.add(st.nextToken());
        }
        int previousValue = -1;
        for (String currentValue : values) {
            if (!this.checkIntValue(currentValue, minimal, maximal)) {
                return false;
            }
            try {
                int val = Integer.parseInt(currentValue);
                if (val <= previousValue) {
                    return false;
                }
                previousValue = val;
            }
            catch (NumberFormatException e) {}
        }
        return true;
    }

    private boolean checkIntValue(String value, int minimal, int maximal) {
        return CronExpressionValidator.checkIntValue(value, minimal, maximal, true);
    }

    private static boolean checkIntValue(String value, int minimal, int maximal, boolean checkExtremity) {
        try {
            int val = Integer.parseInt(value);
            return !checkExtremity || val >= minimal && val <= maximal;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

