/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.Pair;

public abstract class Maps {
    private Maps() {
    }

    public static ColumnSpecification keySpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("key(" + column.name + ")", true), ((MapType)column.type).keys);
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((MapType)column.type).values);
    }

    public static class DiscarderByKey
    extends Operation {
        public DiscarderByKey(ColumnIdentifier column, Term k) {
            super(column, k);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal key = this.t.bind(params.variables);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            assert (key instanceof Constants.Value);
            ByteBuffer cellName = prefix.add(this.columnName.key).add(((Constants.Value)key).bytes).build();
            cf.addColumn(params.makeTombstone(cellName));
        }
    }

    public static class Putter
    extends Operation {
        public Putter(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Putter.doPut(this.t, cf, prefix.add(this.columnName.key), params);
        }

        static void doPut(Term t, ColumnFamily cf, ColumnNameBuilder columnName, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = t.bind(params.variables);
            if (value == null) {
                return;
            }
            assert (value instanceof Value);
            Map<ByteBuffer, ByteBuffer> toAdd = ((Value)value).map;
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : toAdd.entrySet()) {
                ByteBuffer cellName = columnName.copy().add(entry.getKey()).build();
                cf.addColumn(params.makeColumn(cellName, entry.getValue()));
            }
        }
    }

    public static class SetterByKey
    extends Operation {
        private final Term k;

        public SetterByKey(ColumnIdentifier column, Term k, Term t) {
            super(column, t);
            this.k = k;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            super.collectMarkerSpecification(boundNames);
            this.k.collectMarkerSpecification(boundNames);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer key = this.k.bindAndGet(params.variables);
            ByteBuffer value = this.t.bindAndGet(params.variables);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            ByteBuffer cellName = prefix.add(this.columnName.key).add(key).build();
            if (value == null) {
                cf.addColumn(params.makeTombstone(cellName));
            } else {
                if (value.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Map value is too long. Map values are limited to %d bytes but %d bytes value provided", 65535, value.remaining()));
                }
                cf.addColumn(params.makeColumn(cellName, value));
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ColumnNameBuilder column = prefix.add(this.columnName.key);
            cf.addAtom(params.makeTombstoneForOverwrite(column.build(), column.buildAsEndOfRange()));
            Putter.doPut(this.t, cf, column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof MapType);
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer value = values.get(this.bindIndex);
            return value == null ? null : Value.fromSerialized(value, (MapType)this.receiver.type);
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final Comparator<ByteBuffer> comparator;
        private final Map<Term, Term> elements;

        public DelayedValue(Comparator<ByteBuffer> comparator, Map<Term, Term> elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            TreeMap<ByteBuffer, ByteBuffer> buffers = new TreeMap<ByteBuffer, ByteBuffer>(this.comparator);
            for (Map.Entry<Term, Term> entry : this.elements.entrySet()) {
                ByteBuffer keyBytes = entry.getKey().bindAndGet(values);
                if (keyBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (keyBytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Map key is too long. Map keys are limited to %d bytes but %d bytes keys provided", 65535, keyBytes.remaining()));
                }
                ByteBuffer valueBytes = entry.getValue().bindAndGet(values);
                if (valueBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (valueBytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Map value is too long. Map values are limited to %d bytes but %d bytes value provided", 65535, valueBytes.remaining()));
                }
                buffers.put(keyBytes, valueBytes);
            }
            return new Value(buffers);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final Map<ByteBuffer, ByteBuffer> map;

        public Value(Map<ByteBuffer, ByteBuffer> map) {
            this.map = map;
        }

        public static Value fromSerialized(ByteBuffer value, MapType type) throws InvalidRequestException {
            try {
                Map m = (Map)type.compose(value);
                LinkedHashMap<ByteBuffer, ByteBuffer> map = new LinkedHashMap<ByteBuffer, ByteBuffer>(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    map.put(type.keys.decompose(entry.getKey()), type.values.decompose(entry.getValue()));
                }
                return new Value(map);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get() {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(2 * this.map.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : this.map.entrySet()) {
                buffers.add(entry.getKey());
                buffers.add(entry.getValue());
            }
            return CollectionType.pack(buffers, this.map.size());
        }
    }

    public static class Literal
    implements Term.Raw {
        public final List<Pair<Term.Raw, Term.Raw>> entries;

        public Literal(List<Pair<Term.Raw, Term.Raw>> entries) {
            this.entries = entries;
        }

        @Override
        public Term prepare(ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(receiver);
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            HashMap<Term, Term> values = new HashMap<Term, Term>(this.entries.size());
            boolean allTerminal = true;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                Term k = ((Term.Raw)entry.left).prepare(keySpec);
                Term v = ((Term.Raw)entry.right).prepare(valueSpec);
                if (k.containsBindMarker() || v.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: bind variables are not supported inside collection literals", receiver));
                }
                if (k instanceof Term.NonTerminal || v instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.put(k, v);
            }
            DelayedValue value = new DelayedValue(((MapType)receiver.type).keys, values);
            return allTerminal ? value.bind(Collections.emptyList()) : value;
        }

        private void validateAssignableTo(ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof MapType)) {
                throw new InvalidRequestException(String.format("Invalid map literal for %s of type %s", receiver, receiver.type.asCQL3Type()));
            }
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                if (!((Term.Raw)entry.left).isAssignableTo(keySpec)) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: key %s is not of type %s", receiver, entry.left, keySpec.type.asCQL3Type()));
                }
                if (((Term.Raw)entry.right).isAssignableTo(valueSpec)) continue;
                throw new InvalidRequestException(String.format("Invalid map literal for %s: value %s is not of type %s", receiver, entry.right, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            try {
                this.validateAssignableTo(receiver);
                return true;
            }
            catch (InvalidRequestException e) {
                return false;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (int i = 0; i < this.entries.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.entries.get((int)i).left).append(":").append(this.entries.get((int)i).right);
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

