/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.thinkaurelius.thrift.Message;
import com.thinkaurelius.thrift.TDisruptorServer;
import com.thinkaurelius.thrift.util.TBinaryProtocol;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.thrift.TCustomNonblockingServerSocket;
import org.apache.cassandra.thrift.TServerFactory;
import org.apache.cassandra.thrift.ThriftSessionManager;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class THsHaDisruptorServer
extends TDisruptorServer {
    private static final Logger logger = LoggerFactory.getLogger((String)THsHaDisruptorServer.class.getName());

    public THsHaDisruptorServer(TDisruptorServer.Args args) {
        super(args);
        logger.info("Starting up {}", (Object)this);
    }

    protected void beforeInvoke(Message buffer) {
        TNonblockingSocket socket = (TNonblockingSocket)buffer.transport;
        ThriftSessionManager.instance.setCurrentSocket(socket.getSocketChannel().socket().getRemoteSocketAddress());
    }

    public void beforeClose(Message buffer) {
        TNonblockingSocket socket = (TNonblockingSocket)buffer.transport;
        ThriftSessionManager.instance.connectionComplete(socket.getSocketChannel().socket().getRemoteSocketAddress());
    }

    public static class Factory
    implements TServerFactory {
        @Override
        public TServer buildTServer(TServerFactory.Args args) {
            TCustomNonblockingServerSocket serverTransport;
            if (DatabaseDescriptor.getClientEncryptionOptions().enabled) {
                throw new RuntimeException("Client SSL is not supported for non-blocking sockets (hsha). Please remove client ssl from the configuration.");
            }
            InetSocketAddress addr = args.addr;
            try {
                serverTransport = new TCustomNonblockingServerSocket(addr, args.keepAlive, args.sendBufferSize, args.recvBufferSize);
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", addr.getAddress(), addr.getPort()), e);
            }
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory(true, true);
            TDisruptorServer.Args serverArgs = ((TDisruptorServer.Args)((TDisruptorServer.Args)((TDisruptorServer.Args)((TDisruptorServer.Args)((TDisruptorServer.Args)new TDisruptorServer.Args((TNonblockingServerTransport)serverTransport).inputTransportFactory(args.inTransportFactory)).outputTransportFactory(args.outTransportFactory)).inputProtocolFactory((TProtocolFactory)protocolFactory)).outputProtocolFactory((TProtocolFactory)protocolFactory)).processor(args.processor)).maxFrameSizeInBytes(DatabaseDescriptor.getThriftFramedTransportSize());
            return new THsHaDisruptorServer(serverArgs);
        }
    }
}

