/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;

public class Column
implements OnDiskAtom {
    public static final int MAX_NAME_LENGTH = 65535;
    public static final ColumnSerializer serializer = new ColumnSerializer();
    protected final ByteBuffer name;
    protected final ByteBuffer value;
    protected final long timestamp;

    public static OnDiskAtom.Serializer onDiskSerializer() {
        return OnDiskAtom.Serializer.instance;
    }

    public static Iterator<OnDiskAtom> onDiskIterator(final DataInput in, final int count, final ColumnSerializer.Flag flag, final int expireBefore, final Descriptor.Version version) {
        return new AbstractIterator<OnDiskAtom>(){
            int i = 0;

            protected OnDiskAtom computeNext() {
                OnDiskAtom atom;
                if (this.i++ >= count) {
                    return (OnDiskAtom)this.endOfData();
                }
                try {
                    atom = Column.onDiskSerializer().deserializeFromSSTable(in, flag, expireBefore, version);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                if (atom == null) {
                    return (OnDiskAtom)this.endOfData();
                }
                return atom;
            }
        };
    }

    Column(ByteBuffer name) {
        this(name, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    public Column(ByteBuffer name, ByteBuffer value) {
        this(name, value, 0L);
    }

    public Column(ByteBuffer name, ByteBuffer value, long timestamp) {
        assert (name != null);
        assert (value != null);
        assert (name.remaining() <= 65535);
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
    }

    public Column withUpdatedName(ByteBuffer newName) {
        return new Column(newName, this.value, this.timestamp);
    }

    public Column withUpdatedTimestamp(long newTimestamp) {
        return new Column(this.name, this.value, newTimestamp);
    }

    @Override
    public ByteBuffer name() {
        return this.name;
    }

    public ByteBuffer value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long minTimestamp() {
        return this.timestamp;
    }

    @Override
    public long maxTimestamp() {
        return this.timestamp;
    }

    public boolean isMarkedForDelete(long now) {
        return false;
    }

    public boolean isLive(long now) {
        return !this.isMarkedForDelete(now);
    }

    public long getMarkedForDeleteAt() {
        return Long.MAX_VALUE;
    }

    public int dataSize() {
        return this.name().remaining() + this.value.remaining() + TypeSizes.NATIVE.sizeof(this.timestamp);
    }

    @Override
    public int serializedSize(TypeSizes typeSizes) {
        int nameSize = this.name.remaining();
        int valueSize = this.value.remaining();
        return typeSizes.sizeof((short)nameSize) + nameSize + 1 + typeSizes.sizeof(this.timestamp) + typeSizes.sizeof(valueSize) + valueSize;
    }

    @Override
    public long serializedSizeForSSTable() {
        return this.serializedSize(TypeSizes.NATIVE);
    }

    public int serializationFlags() {
        return 0;
    }

    public Column diff(Column column) {
        if (this.timestamp() < column.timestamp()) {
            return column;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        digest.update(this.value.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return Integer.MAX_VALUE;
    }

    public Column reconcile(Column column) {
        return this.reconcile(column, HeapAllocator.instance);
    }

    public Column reconcile(Column column, Allocator allocator) {
        if (this.isMarkedForDelete(System.currentTimeMillis())) {
            return this.timestamp() < column.timestamp() ? column : this;
        }
        if (column.isMarkedForDelete(System.currentTimeMillis())) {
            return this.timestamp() > column.timestamp() ? this : column;
        }
        if (this.timestamp() == column.timestamp()) {
            return this.value().compareTo(column.value()) < 0 ? column : this;
        }
        return this.timestamp() < column.timestamp() ? column : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        if (this.timestamp != column.timestamp) {
            return false;
        }
        if (!this.name.equals(column.name)) {
            return false;
        }
        return this.value.equals(column.value);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public Column localCopy(ColumnFamilyStore cfs) {
        return this.localCopy(cfs, HeapAllocator.instance);
    }

    public Column localCopy(ColumnFamilyStore cfs, Allocator allocator) {
        return new Column(cfs.internOrCopy(this.name, allocator), allocator.clone(this.value), this.timestamp);
    }

    public String getString(AbstractType<?> comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(comparator.getString(this.name));
        sb.append(":");
        sb.append(this.isMarkedForDelete(System.currentTimeMillis()));
        sb.append(":");
        sb.append(this.value.remaining());
        sb.append("@");
        sb.append(this.timestamp());
        return sb.toString();
    }

    protected void validateName(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate(this.name());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        CFDefinition cfdef = metadata.getCfDef();
        ByteBuffer internalName = cfdef.isComposite && !cfdef.isCompact ? ((CompositeType)metadata.comparator).extractLastComponent(this.name) : this.name;
        AbstractType<?> valueValidator = metadata.getValueValidator(internalName);
        if (valueValidator != null) {
            valueValidator.validate(this.value());
        }
    }

    public boolean hasIrrelevantData(int gcBefore) {
        return this.getLocalDeletionTime() < gcBefore;
    }

    public static Column create(ByteBuffer name, ByteBuffer value, long timestamp, int ttl, CFMetaData metadata) {
        if (ttl <= 0) {
            ttl = metadata.getDefaultTimeToLive();
        }
        return ttl > 0 ? new ExpiringColumn(name, value, timestamp, ttl) : new Column(name, value, timestamp);
    }

    public static Column create(String value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), UTF8Type.instance.decompose(value), timestamp);
    }

    public static Column create(int value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), Int32Type.instance.decompose(value), timestamp);
    }

    public static Column create(boolean value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), BooleanType.instance.decompose(value), timestamp);
    }

    public static Column create(double value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), DoubleType.instance.decompose(value), timestamp);
    }

    public static Column create(ByteBuffer value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), value, timestamp);
    }

    public static Column create(InetAddress value, long timestamp, String ... names) {
        return new Column(Column.decomposeName(names), InetAddressType.instance.decompose(value), timestamp);
    }

    static ByteBuffer decomposeName(String ... names) {
        assert (names.length > 0);
        if (names.length == 1) {
            return UTF8Type.instance.decompose(names[0]);
        }
        ArrayList types = new ArrayList(names.length);
        for (int i = 0; i < names.length; ++i) {
            types.add(UTF8Type.instance);
        }
        CompositeType.Builder builder = new CompositeType.Builder(CompositeType.getInstance(types));
        for (String name : names) {
            builder.add(UTF8Type.instance.decompose(name));
        }
        return builder.build();
    }
}

