/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.downloader;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.shared.downloader.DownloadException;
import org.apache.maven.shared.downloader.DownloadNotFoundException;
import org.apache.maven.shared.downloader.Downloader;

public class DefaultDownloader
implements Downloader {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;

    public File download(String groupId, String artifactId, String version, File localRepository, String[] remoteRepositories) throws DownloadException, DownloadNotFoundException {
        return this.download(groupId, artifactId, version, localRepository, remoteRepositories);
    }

    public File download(String groupId, String artifactId, String version, ArtifactRepository localRepository, List remoteRepositories) throws DownloadException, DownloadNotFoundException {
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        try {
            this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Error downloading.", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DownloadNotFoundException("Requested download does not exist.", e);
        }
        return artifact.getFile();
    }
}

