/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.datatorrent.stram.tuple;

import java.util.UUID;

import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;

import com.datatorrent.bufferserver.packet.MessageType;

/**
 * An implementation for @{@link Tuple} which can be generated by the user
 * Acts as the wrapper for the user payload
 *
 * @since 3.6.0
 */
public class CustomControlTuple extends Tuple
{
  private final Object userObject;
  @FieldSerializer.Bind(JavaSerializer.class)
  private final UUID uid;

  protected CustomControlTuple()
  {
    // for Kryo
    super(MessageType.CUSTOM_CONTROL, 0);
    userObject = null;
    uid = null;
  }

  public CustomControlTuple(Object userObject)
  {
    super(MessageType.CUSTOM_CONTROL, 0);
    this.userObject = userObject;
    uid = UUID.randomUUID();
  }

  public Object getUserObject()
  {
    return userObject;
  }

  public UUID getUid()
  {
    return uid;
  }
}
