/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.apex.api;

import org.apache.apex.api.operator.ControlTuple;
import org.apache.hadoop.classification.InterfaceStability;

import com.datatorrent.api.ControlTupleEnabledSink;
import com.datatorrent.api.DefaultInputPort;

/**
 * Default abstract implementation for an input port which is capable of processing
 * @{@link UserDefinedControlTuple}
 *
 * @since 3.6.0
 */
@InterfaceStability.Evolving
public abstract class ControlAwareDefaultInputPort<T> extends DefaultInputPort<T> implements ControlTupleEnabledSink<T>
{
  @Override
  public boolean putControl(ControlTuple payload)
  {
    count++;
    return processControl(payload);
  }

  /**
   * Process the control tuples
   *
   * @param payload the control tuple payload generated by upstream operator(s)
   */
  public abstract boolean processControl(ControlTuple payload);
}
