/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity.locality;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.modularity.locality.LocalityClass;
import org.semanticweb.owlapi.modularity.locality.LocalityEvaluator;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class SemanticLocalityEvaluator
implements LocalityEvaluator {
    @Nonnull
    protected final OWLDataFactory dataFactory;
    @Nonnull
    private final OWLReasoner reasoner;
    private final LocalityClass localityClass;

    public SemanticLocalityEvaluator(LocalityClass localityClass, OWLOntologyManager ontologyManager, OWLReasonerFactory reasonerFactory) {
        this.localityClass = Objects.requireNonNull(localityClass, "The given  locality class may not be null.");
        if (localityClass != LocalityClass.BOTTOM || localityClass != LocalityClass.TOP) {
            throw new IllegalArgumentException("The given locality class must be one of BOTTOM or TOP");
        }
        this.dataFactory = Objects.requireNonNull(ontologyManager, "The given ontologyManager may not be null").getOWLDataFactory();
        try {
            this.reasoner = Objects.requireNonNull(reasonerFactory, "The given reasonerFactory may not be null").createNonBufferingReasoner(ontologyManager.createOntology());
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Collection<OWLEntity> signature) {
        return !axiom.isLogicalAxiom() || this.reasoner.isEntailed(this.localityClass == LocalityClass.BOTTOM ? new BottomReplacer(Objects.requireNonNull(signature, "signature cannot be null")).replaceBottom(Objects.requireNonNull(axiom, "The given axiom may not be null")) : new TopReplacer(Objects.requireNonNull(signature, "signature cannot be null")).replaceTop(Objects.requireNonNull(axiom, "The given axiom may not be null")));
    }

    private class TopReplacer
    implements OWLAxiomVisitor,
    OWLClassExpressionVisitor {
        @Nullable
        private OWLAxiom newAxiom;
        @Nullable
        private OWLClassExpression newClassExpression;
        @Nonnull
        private final Collection<OWLEntity> signature;

        TopReplacer(Collection<OWLEntity> signature) {
            this.signature = signature;
        }

        @Nonnull
        public OWLAxiom replaceTop(OWLAxiom axiom) {
            this.newAxiom = null;
            axiom.accept((OWLAxiomVisitor)this);
            if (this.newAxiom == null) {
                throw new OWLRuntimeException("Unsupported axiom: " + axiom);
            }
            return (OWLAxiom)OWLAPIPreconditions.verifyNotNull((Object)this.newAxiom);
        }

        @Nonnull
        public OWLClassExpression replaceTop(OWLClassExpression classExpression) {
            this.newClassExpression = null;
            classExpression.accept((OWLClassExpressionVisitor)this);
            if (this.newClassExpression == null) {
                throw new OWLRuntimeException("Unsupported class expression: " + classExpression);
            }
            return (OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.newClassExpression);
        }

        @Nonnull
        public Stream<OWLClassExpression> replaceTop(Stream<? extends OWLClassExpression> classExpressions) {
            return classExpressions.map(this::replaceTop);
        }

        public void visit(@Nonnull OWLClass ce) {
            this.newClassExpression = this.signature.contains(ce) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDataAllValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDataExactCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDataHasValue ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDataMaxCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDataMinCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDataSomeValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.newAxiom = SemanticLocalityEvaluator.this.dataFactory.getOWLDisjointClassesAxiom(this.replaceTop(axiom.classExpressions()));
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.newAxiom = SemanticLocalityEvaluator.this.dataFactory.getOWLEquivalentClassesAxiom(this.replaceTop(axiom.classExpressions()));
        }

        public void visit(OWLObjectAllValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? SemanticLocalityEvaluator.this.dataFactory.getOWLObjectAllValuesFrom(ce.getProperty(), this.replaceTop((OWLClassExpression)ce.getFiller())) : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectComplementOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLObjectComplementOf(this.replaceTop(ce.getOperand()));
        }

        public void visit(OWLObjectExactCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectHasSelf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectHasValue ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectIntersectionOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLObjectIntersectionOf(this.replaceTop(ce.operands()));
        }

        public void visit(OWLObjectMaxCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectMinCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectOneOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectSomeValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? SemanticLocalityEvaluator.this.dataFactory.getOWLObjectSomeValuesFrom(ce.getProperty(), this.replaceTop((OWLClassExpression)ce.getFiller())) : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectUnionOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLObjectUnionOf(this.replaceTop(ce.operands()));
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.newAxiom = SemanticLocalityEvaluator.this.dataFactory.getOWLSubClassOfAxiom(this.replaceTop(axiom.getSuperClass()), this.replaceTop(axiom.getSubClass()));
        }
    }

    private class BottomReplacer
    implements OWLAxiomVisitor,
    OWLClassExpressionVisitor {
        @Nullable
        private OWLAxiom newAxiom;
        @Nullable
        private OWLClassExpression newClassExpression;
        @Nonnull
        private final Collection<OWLEntity> signature;

        BottomReplacer(Collection<OWLEntity> signature) {
            this.signature = signature;
        }

        @Nonnull
        public OWLAxiom replaceBottom(OWLAxiom axiom) {
            this.newAxiom = null;
            axiom.accept((OWLAxiomVisitor)this);
            if (this.newAxiom == null) {
                throw new OWLRuntimeException("Unsupported axiom: " + axiom);
            }
            return (OWLAxiom)OWLAPIPreconditions.verifyNotNull((Object)this.newAxiom);
        }

        @Nonnull
        public OWLClassExpression replaceBottom(OWLClassExpression classExpression) {
            this.newClassExpression = null;
            classExpression.accept((OWLClassExpressionVisitor)this);
            if (this.newClassExpression == null) {
                throw new OWLRuntimeException("Unsupported class expression: " + classExpression);
            }
            return (OWLClassExpression)OWLAPIPreconditions.verifyNotNull((Object)this.newClassExpression);
        }

        @Nonnull
        public Stream<OWLClassExpression> replaceBottom(Stream<? extends OWLClassExpression> classExpressions) {
            return classExpressions.map(this::replaceBottom);
        }

        public void visit(@Nonnull OWLClass ce) {
            this.newClassExpression = this.signature.contains(ce) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDataAllValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDataExactCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDataHasValue ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDataMaxCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLDataMinCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDataSomeValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.newAxiom = SemanticLocalityEvaluator.this.dataFactory.getOWLDisjointClassesAxiom(this.replaceBottom(axiom.classExpressions()));
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.newAxiom = SemanticLocalityEvaluator.this.dataFactory.getOWLEquivalentClassesAxiom(this.replaceBottom(axiom.classExpressions()));
        }

        public void visit(OWLObjectAllValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? SemanticLocalityEvaluator.this.dataFactory.getOWLObjectAllValuesFrom(ce.getProperty(), this.replaceBottom((OWLClassExpression)ce.getFiller())) : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectComplementOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLObjectComplementOf(this.replaceBottom(ce.getOperand()));
        }

        public void visit(OWLObjectExactCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectHasSelf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectHasValue ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectIntersectionOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLObjectIntersectionOf(this.replaceBottom(ce.operands()));
        }

        public void visit(OWLObjectMaxCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLThing();
        }

        public void visit(OWLObjectMinCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectOneOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectSomeValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? SemanticLocalityEvaluator.this.dataFactory.getOWLObjectSomeValuesFrom(ce.getProperty(), this.replaceBottom((OWLClassExpression)ce.getFiller())) : SemanticLocalityEvaluator.this.dataFactory.getOWLNothing();
        }

        public void visit(OWLObjectUnionOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.dataFactory.getOWLObjectUnionOf(this.replaceBottom(ce.operands()));
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.newAxiom = SemanticLocalityEvaluator.this.dataFactory.getOWLSubClassOfAxiom(this.replaceBottom(axiom.getSuperClass()), this.replaceBottom(axiom.getSubClass()));
        }
    }
}

