/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.WordPerfect;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.wordperfect.WP5DocumentAreaExtractor;
import org.apache.tika.parser.wordperfect.WP6DocumentAreaExtractor;
import org.apache.tika.parser.wordperfect.WPDocumentAreaExtractor;
import org.apache.tika.parser.wordperfect.WPInputStream;
import org.apache.tika.parser.wordperfect.WPPrefixArea;
import org.apache.tika.parser.wordperfect.WPPrefixAreaExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WordPerfectParser
extends AbstractParser {
    static final MediaType WP_BASE = MediaType.application((String)"vnd.wordperfect");
    static final MediaType WP_UNK = new MediaType(WP_BASE, "version", "unknown");
    static final MediaType WP_5_0 = new MediaType(WP_BASE, "version", "5.0");
    static final MediaType WP_5_1 = new MediaType(WP_BASE, "version", "5.1");
    static final MediaType WP_6_x = new MediaType(WP_BASE, "version", "6.x");
    private static final long serialVersionUID = 8941810225917012232L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(WP_5_0, WP_5_1, WP_6_x)));
    @Field
    private boolean includeDeletedContent = true;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        WPInputStream wpStream = new WPInputStream(stream);
        WPPrefixArea prefixArea = WPPrefixAreaExtractor.extract(wpStream);
        this.ensureFileSupport(prefixArea, metadata);
        this.applyMetadata(prefixArea, metadata);
        this.extractDocumentArea(prefixArea, wpStream, new XHTMLContentHandler(handler, metadata));
    }

    private void extractDocumentArea(WPPrefixArea prefixArea, WPInputStream in, XHTMLContentHandler xhtml) throws SAXException, IOException {
        int i = 0;
        while ((long)i < prefixArea.getDocAreaPointer()) {
            in.readWPByte();
            ++i;
        }
        xhtml.startDocument();
        this.getDocumentAreaExtractor(prefixArea).extract(in, xhtml);
        xhtml.endDocument();
    }

    private void ensureFileSupport(WPPrefixArea pa, Metadata metadata) throws UnsupportedFormatException, EncryptedDocumentException {
        if (pa.getMajorVersion() != 0 && pa.getMajorVersion() != 2) {
            metadata.set("Content-Type", WP_UNK.toString());
            throw new UnsupportedFormatException("Parser doesn't recognize this major version: " + pa.getMajorVersion());
        }
        if (pa.isEncrypted()) {
            throw new EncryptedDocumentException();
        }
    }

    private void applyMetadata(WPPrefixArea pa, Metadata metadata) {
        if (metadata.get("Content-Type") == null) {
            if (pa.getMajorVersion() == 2) {
                metadata.set("Content-Type", WP_6_x.toString());
            } else if (pa.getMinorVersion() == 0) {
                metadata.set("Content-Type", WP_5_0.toString());
            } else if (pa.getMinorVersion() == 1) {
                metadata.set("Content-Type", WP_5_1.toString());
            } else {
                metadata.set("Content-Type", WP_BASE.toString());
            }
        }
        metadata.set(WordPerfect.FILE_ID, pa.getFileId());
        metadata.set(WordPerfect.PRODUCT_TYPE, pa.getProductType());
        metadata.set(WordPerfect.FILE_TYPE, pa.getFileType());
        metadata.set(WordPerfect.MAJOR_VERSION, pa.getMajorVersion());
        metadata.set(WordPerfect.MINOR_VERSION, pa.getMinorVersion());
        metadata.set(WordPerfect.ENCRYPTED, Boolean.toString(pa.isEncrypted()));
        if (pa.getFileSize() > -1L) {
            metadata.set(WordPerfect.FILE_SIZE, Long.toString(pa.getFileSize()));
        }
    }

    private WPDocumentAreaExtractor getDocumentAreaExtractor(WPPrefixArea prefixArea) {
        if (prefixArea.getMajorVersion() == 2) {
            return new WP6DocumentAreaExtractor(this.includeDeletedContent);
        }
        return new WP5DocumentAreaExtractor();
    }

    @Field
    public void setIncludeDeletedContent(boolean includeDeletedContent) {
        this.includeDeletedContent = includeDeletedContent;
    }
}

