/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.ICalendar;
import biweekly.component.VTimezone;
import biweekly.io.TimezoneInfo;
import biweekly.io.text.ICalReader;
import biweekly.property.TimezoneId;
import biweekly.property.ValuedProperty;
import biweekly.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TzUrlDotOrgGenerator {
    private static final Map<URI, VTimezone> cache = Collections.synchronizedMap(new HashMap());
    private final String baseUrl;

    public TzUrlDotOrgGenerator(boolean outlookCompatible) {
        this.baseUrl = "http://www.tzurl.org/zoneinfo" + (outlookCompatible ? "-outlook" : "") + "/";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VTimezone generate(TimeZone timezone) throws IllegalArgumentException {
        ICalendar ical;
        URI uri;
        try {
            uri = new URI(this.baseUrl + timezone.getID());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        VTimezone component = cache.get(uri);
        if (component != null) {
            return component.copy();
        }
        ICalReader reader = null;
        try {
            reader = new ICalReader(this.getInputStream(uri));
            ical = reader.readNext();
        }
        catch (FileNotFoundException e) {
            try {
                throw TzUrlDotOrgGenerator.notFound(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        if (ical == null) {
            throw TzUrlDotOrgGenerator.notFound(null);
        }
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        Collection<VTimezone> components = tzinfo.getComponents();
        if (components.isEmpty() && (components = ical.getComponents(VTimezone.class)).isEmpty()) {
            throw TzUrlDotOrgGenerator.notFound(null);
        }
        component = components.iterator().next();
        TimezoneId id = component.getTimezoneId();
        if (id == null) {
            component.setTimezoneId(timezone.getID());
        } else {
            String value = ValuedProperty.getValue(id);
            if (value == null || value.trim().isEmpty()) {
                id.setValue(timezone.getID());
            }
        }
        cache.put(uri, component);
        return component.copy();
    }

    InputStream getInputStream(URI uri) throws IOException {
        return uri.toURL().openStream();
    }

    public static void clearCache() {
        cache.clear();
    }

    private static IllegalArgumentException notFound(Exception e) {
        return new IllegalArgumentException("Timezone ID not recognized.", e);
    }
}

