/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.Messages;
import biweekly.component.ICalComponent;
import biweekly.component.RawComponent;
import biweekly.component.VTimezone;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.WriteContext;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class StreamWriter
implements Closeable {
    protected ScribeIndex index = new ScribeIndex();
    protected WriteContext context;
    protected TimezoneAssignment globalTimezone;
    private TimezoneInfo tzinfo;

    public void write(ICalendar ical) throws IOException {
        Collection<Class<?>> unregistered = this.findScribeless(ical);
        if (!unregistered.isEmpty()) {
            ArrayList<String> classNames = new ArrayList<String>(unregistered.size());
            for (Class<?> clazz : unregistered) {
                classNames.add(clazz.getName());
            }
            throw Messages.INSTANCE.getIllegalArgumentException(13, classNames);
        }
        this.tzinfo = ical.getTimezoneInfo();
        this.context = new WriteContext(this.getTargetVersion(), this.tzinfo, this.globalTimezone);
        this._write(ical);
    }

    protected Collection<VTimezone> getTimezoneComponents() {
        if (this.globalTimezone != null) {
            VTimezone component = this.globalTimezone.getComponent();
            return component == null ? Collections.emptyList() : Collections.singletonList(component);
        }
        return this.tzinfo.getComponents();
    }

    protected abstract ICalVersion getTargetVersion();

    protected abstract void _write(ICalendar var1) throws IOException;

    public TimezoneAssignment getGlobalTimezone() {
        return this.globalTimezone;
    }

    public void setGlobalTimezone(TimezoneAssignment globalTimezone) {
        this.globalTimezone = globalTimezone;
    }

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex scribe) {
        this.index = scribe;
    }

    private Collection<Class<?>> findScribeless(ICalendar ical) {
        HashSet unregistered = new HashSet();
        LinkedList<ICalComponent> components = new LinkedList<ICalComponent>();
        components.add(ical);
        while (!components.isEmpty()) {
            ICalComponent component = (ICalComponent)components.removeLast();
            Class<?> componentClass = component.getClass();
            if (componentClass != RawComponent.class && this.index.getComponentScribe(componentClass) == null) {
                unregistered.add(componentClass);
            }
            for (Map.Entry<Class<? extends ICalProperty>, List<ICalProperty>> entry : component.getProperties()) {
                Class<? extends ICalProperty> clazz;
                List<ICalProperty> properties = entry.getValue();
                if (properties.isEmpty() || (clazz = entry.getKey()) == RawProperty.class || this.index.getPropertyScribe(clazz) != null) continue;
                unregistered.add(clazz);
            }
            components.addAll(component.getComponents().values());
        }
        return unregistered;
    }
}

