/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.ShortIndexedContainer;
import java.util.Arrays;

public final class ShortArrays {
    public static final short[] EMPTY = new short[0];
    private static final int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;
    private static final int BLANK_ARRAY_SIZE = 1024;
    private static final short[] BLANKING_OBJECT_ARRAY = new short[1024];

    private ShortArrays() {
    }

    public static void rotate(short[] table, int from, int mid, int to) {
        ShortArrays.reverse(table, from, mid);
        ShortArrays.reverse(table, mid, to);
        ShortArrays.reverse(table, from, to);
    }

    public static void rotate(ShortIndexedContainer table, int from, int mid, int to) {
        ShortArrays.reverse(table, from, mid);
        ShortArrays.reverse(table, mid, to);
        ShortArrays.reverse(table, from, to);
    }

    public static void reverse(short[] table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            short tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    public static void reverse(ShortIndexedContainer table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            short tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    public static void blankArray(short[] objectArray, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        int size = endIndex - startIndex;
        int nbChunks = size >> 10;
        int rem = size & 0x3FF;
        for (int i = 0; i < nbChunks; ++i) {
            System.arraycopy(BLANKING_OBJECT_ARRAY, 0, objectArray, startIndex + (i << 10), 1024);
        }
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << 10), startIndex + (nbChunks << 10) + rem, (short)0);
        }
    }
}

