/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.booter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.mojo.appassembler.model.io.stax.AppassemblerModelStaxReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public class AppassemblerBooter {
    private static boolean debug;
    private static Daemon config;
    private static String mainClassName;

    private AppassemblerBooter() {
    }

    public static void main(String[] args) throws Exception {
        URLClassLoader classLoader = AppassemblerBooter.setup();
        AppassemblerBooter.executeMain(classLoader, args);
    }

    public static URLClassLoader setup() throws IOException, XMLStreamException {
        String appName = System.getProperty("app.name");
        if (appName == null) {
            throw new RuntimeException("Missing required system property 'app.name'.");
        }
        debug = Boolean.getBoolean("app.booter.debug");
        String b = System.getProperty("basedir");
        if (b == null) {
            throw new RuntimeException("Missing required system property 'basedir'.");
        }
        String r = System.getProperty("app.repo", b);
        File repoDir = new File(r);
        config = AppassemblerBooter.loadConfig(appName);
        mainClassName = config.getMainClass();
        if (AppassemblerBooter.isEmpty(mainClassName)) {
            throw new RuntimeException("Missing required property from configuration: 'mainClass'.");
        }
        AppassemblerBooter.setSystemProperties();
        return AppassemblerBooter.createClassLoader(repoDir);
    }

    public static URLClassLoader createClassLoader(File repoDir) throws MalformedURLException {
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        StringBuilder appClassPath = new StringBuilder();
        boolean firstAppClassPathElement = true;
        for (ClasspathElement element : config.getAllClasspathElements()) {
            File artifact = new File(repoDir, element.getRelativePath());
            if (debug) {
                System.err.println("Adding file to classpath: " + artifact.getAbsolutePath());
            }
            classpathUrls.add(artifact.toURL());
            if (firstAppClassPathElement) {
                firstAppClassPathElement = false;
            } else {
                appClassPath.append(File.pathSeparator);
            }
            appClassPath.append(artifact.getAbsolutePath());
        }
        System.setProperty("app.class.path", appClassPath.toString());
        URL[] urls = classpathUrls.toArray(new URL[classpathUrls.size()]);
        return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    public static void setSystemProperties() {
        JvmSettings jvmSettings = config.getJvmSettings();
        if (jvmSettings != null && jvmSettings.getSystemProperties() != null) {
            for (String line : jvmSettings.getSystemProperties()) {
                try {
                    String[] strings = line.split("=");
                    String key = strings[0];
                    String value = strings[1];
                    if (debug) {
                        System.err.println("Setting system property '" + key + "' to '" + value + "'.");
                    }
                    System.setProperty(key, value);
                }
                catch (Throwable e) {
                    if (!debug) continue;
                    System.err.println("Error Setting system property with value '" + line + "'.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Daemon loadConfig(String appName) throws IOException, XMLStreamException {
        String resourceName = "/" + appName + ".xml";
        InputStream resource = AppassemblerBooter.class.getResourceAsStream(resourceName);
        if (debug) {
            System.err.println("Loading configuration file from: " + resourceName);
        }
        if (resource == null) {
            throw new RuntimeException("Could not load configuration resource: '" + resourceName + "'.");
        }
        try {
            AppassemblerModelStaxReader reader = new AppassemblerModelStaxReader();
            Daemon daemon = reader.read((Reader)new InputStreamReader(resource, "UTF-8"));
            return daemon;
        }
        finally {
            resource.close();
        }
    }

    public static void executeMain(URLClassLoader classLoader, String[] args) throws Exception {
        List<String> arguments = config.getCommandLineArguments();
        Class<?> mainClass = classLoader.loadClass(mainClassName);
        Method main = mainClass.getMethod("main", String[].class);
        if (arguments == null) {
            arguments = Arrays.asList(args);
        } else {
            arguments.addAll(Arrays.asList(args));
        }
        String[] commandLineArgs = AppassemblerBooter.interpolateArguments(arguments.toArray(new String[arguments.size()]));
        Thread.currentThread().setContextClassLoader(classLoader);
        main.invoke(null, new Object[]{commandLineArgs});
    }

    private static String[] interpolateArguments(String[] arguments) {
        if (arguments == null) {
            return null;
        }
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = AppassemblerBooter.interpolateBaseDirAndRepo(arguments[i]);
        }
        return arguments;
    }

    private static String interpolateBaseDirAndRepo(String content) {
        String repo;
        StringReader sr = new StringReader(content);
        StringWriter result = new StringWriter();
        HashMap<String, String> context = new HashMap<String, String>();
        String baseDir = System.getProperty("basedir", System.getProperty("app.home"));
        if (baseDir != null && baseDir.length() > 0) {
            context.put("BASEDIR", StringUtils.quoteAndEscape((String)baseDir, (char)'\"'));
        }
        if ((repo = System.getProperty("app.repo")) != null && repo.length() > 0) {
            context.put("REPO", StringUtils.quoteAndEscape((String)repo, (char)'\"'));
        }
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)sr, context, "@", "@");
        try {
            IOUtil.copy((Reader)interpolationFilterReader, (Writer)result);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }

    private static boolean isEmpty(String mainClass) {
        return mainClass == null || mainClass.trim().length() == 0;
    }
}

