/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import org.apache.any23.cli.BaseTool;
import org.apache.any23.extractor.ExampleInputOutput;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.extractor.ExtractorRegistry;
import org.apache.any23.extractor.ExtractorRegistryImpl;

@Parameters(commandNames={"extractor"}, commandDescription="Utility for obtaining documentation about metadata extractors.")
public class ExtractorDocumentation
extends BaseTool {
    @Parameter(names={"-l", "--list"}, description="shows the names, labels and supported mimetypes of all available extractors")
    private boolean showList;
    @Parameter(names={"-i", "--input"}, description="shows example input for the given extractor")
    private String input;
    @Parameter(names={"-o", "--output"}, description="shows example output for the given extractor")
    private String output;
    @Parameter(names={"-a", "--all"}, description="shows a report about all available extractors")
    private boolean showAll;
    private PrintStream out = System.out;

    @Override
    PrintStream getOut() {
        return this.out;
    }

    @Override
    void setOut(PrintStream out) {
        this.out = out;
    }

    public void run() throws Exception {
        if (this.showList) {
            this.printExtractorList(ExtractorRegistryImpl.getInstance());
        } else if (this.input != null) {
            this.printExampleInput(this.input, ExtractorRegistryImpl.getInstance());
        } else if (this.output != null) {
            this.printExampleOutput(this.output, ExtractorRegistryImpl.getInstance());
        } else if (this.showAll) {
            this.printReport(ExtractorRegistryImpl.getInstance());
        }
    }

    public void printError(String msg) {
        System.err.println(msg);
    }

    public void printExtractorList(ExtractorRegistry registry) {
        for (ExtractorFactory factory : registry.getExtractorGroup()) {
            this.out.println(String.format(Locale.ROOT, "%25s [%15s] %15s", factory.getExtractorName(), factory.getExtractorLabel(), factory.getSupportedMIMETypes()));
        }
    }

    public void printExampleInput(String extractorName, ExtractorRegistry registry) throws IOException {
        ExtractorFactory<?> factory = this.getFactory(registry, extractorName);
        ExampleInputOutput example = new ExampleInputOutput(factory);
        String input = example.getExampleInput();
        if (input == null) {
            throw new IllegalArgumentException("Extractor " + extractorName + " provides no example input");
        }
        this.out.println(input);
    }

    public void printExampleOutput(String extractorName, ExtractorRegistry registry) throws IOException, ExtractionException {
        ExtractorFactory<?> factory = this.getFactory(registry, extractorName);
        ExampleInputOutput example = new ExampleInputOutput(factory);
        String output = example.getExampleOutput();
        if (output == null) {
            throw new IllegalArgumentException("Extractor " + extractorName + " provides no example output");
        }
        this.out.println(output);
    }

    public void printReport(ExtractorRegistry registry) throws IOException, ExtractionException {
        for (String extractorName : registry.getAllNames()) {
            ExtractorFactory factory = registry.getFactory(extractorName);
            ExampleInputOutput example = new ExampleInputOutput(factory);
            this.out.println("Extractor: " + extractorName);
            this.out.println("\ttype: " + this.getType(factory));
            this.out.println();
            String exampleInput = example.getExampleInput();
            if (exampleInput == null) {
                this.out.println("(No Example Available)");
            } else {
                this.out.println("-------- Example Input  --------");
                this.out.println(exampleInput);
                this.out.println("-------- Example Output --------");
                String output = example.getExampleOutput();
                this.out.println(output == null || output.trim().length() == 0 ? "(No Output Generated)" : output);
            }
            this.out.println("================================");
            this.out.println();
        }
    }

    private ExtractorFactory<?> getFactory(ExtractorRegistry registry, String name) {
        if (!registry.isRegisteredName(name)) {
            throw new IllegalArgumentException("Unknown extractor name: " + name);
        }
        return registry.getFactory(name);
    }

    private String getType(ExtractorFactory<?> factory) {
        Extractor extractor = factory.createExtractor();
        if (extractor instanceof Extractor.BlindExtractor) {
            return Extractor.BlindExtractor.class.getSimpleName();
        }
        if (extractor instanceof Extractor.TagSoupDOMExtractor) {
            return Extractor.TagSoupDOMExtractor.class.getSimpleName();
        }
        if (extractor instanceof Extractor.ContentExtractor) {
            return Extractor.ContentExtractor.class.getSimpleName();
        }
        return "?";
    }
}

