/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.util.StringUtils;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class LoggingTripleHandler
implements TripleHandler {
    private final TripleHandler underlyingHandler;
    private final Map<String, Integer> contextTripleMap = new HashMap<String, Integer>();
    private long startTime = 0L;
    private long contentLength = 0L;
    private final PrintWriter destination;

    public LoggingTripleHandler(TripleHandler tripleHandler, PrintWriter destination) {
        if (tripleHandler == null) {
            throw new NullPointerException("tripleHandler cannot be null.");
        }
        if (destination == null) {
            throw new NullPointerException("destination cannot be null.");
        }
        this.underlyingHandler = tripleHandler;
        this.destination = destination;
        this.printHeader(destination);
    }

    public void startDocument(IRI documentIRI) throws TripleHandlerException {
        this.underlyingHandler.startDocument(documentIRI);
        this.startTime = System.currentTimeMillis();
    }

    public void close() throws TripleHandlerException {
        this.underlyingHandler.close();
        this.destination.flush();
        this.destination.close();
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        this.underlyingHandler.closeContext(context);
    }

    public void openContext(ExtractionContext context) throws TripleHandlerException {
        this.underlyingHandler.openContext(context);
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        this.underlyingHandler.receiveTriple(s, p, o, g, context);
        Integer i = this.contextTripleMap.get(context.getExtractorName());
        if (i == null) {
            i = 0;
        }
        this.contextTripleMap.put(context.getExtractorName(), i + 1);
    }

    public void receiveNamespace(String prefix, String uri, ExtractionContext context) throws TripleHandlerException {
        this.underlyingHandler.receiveNamespace(prefix, uri, context);
    }

    public void endDocument(IRI documentIRI) throws TripleHandlerException {
        this.underlyingHandler.endDocument(documentIRI);
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        AtomicBoolean success = new AtomicBoolean(true);
        StringBuilder sb = new StringBuilder("[ ");
        String[] parsers = this.contextTripleMap.entrySet().stream().map(e -> {
            if ((Integer)e.getValue() > 0) {
                success.set(true);
            }
            return String.format(Locale.ROOT, "%s:%d", e.getKey(), e.getValue());
        }).collect(Collectors.toList()).toArray(new String[0]);
        sb.append(StringUtils.join(", ", parsers));
        sb.append(" ]");
        this.destination.println(documentIRI + "\t" + this.contentLength + "\t" + elapsedTime + "\t" + success.get() + "\t" + sb.toString());
        this.contextTripleMap.clear();
    }

    public void setContentLength(long contentLength) {
        this.underlyingHandler.setContentLength(contentLength);
        this.contentLength = contentLength;
    }

    private void printHeader(PrintWriter writer) {
        writer.println("# Document-IRI\tContent-Length\tElapsed-Time\tSuccess\tExtractors:Triples");
    }
}

