/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.validator.rule;

import java.util.List;
import org.apache.any23.validator.DOMDocument;
import org.apache.any23.validator.Rule;
import org.apache.any23.validator.RuleContext;
import org.apache.any23.validator.ValidationReport;
import org.apache.any23.validator.ValidationReportBuilder;
import org.w3c.dom.Node;

public class MissingOpenGraphNamespaceRule
implements Rule {
    @Override
    public String getHRName() {
        return "missing-opengraph-namespace-rule";
    }

    public boolean applyOn(DOMDocument document, RuleContext context, ValidationReportBuilder validationReportBuilder) {
        Node htmlNode;
        List<Node> metas = document.getNodes("/HTML/HEAD/META");
        boolean foundPrecondition = false;
        for (Node meta : metas) {
            Node propertyNode = meta.getAttributes().getNamedItem("property");
            if (propertyNode == null || propertyNode.getTextContent().indexOf("og:") != 0) continue;
            foundPrecondition = true;
            break;
        }
        if (foundPrecondition && (htmlNode = document.getNode("/HTML")).getAttributes().getNamedItem("xmlns:og") == null) {
            validationReportBuilder.reportIssue(ValidationReport.IssueLevel.ERROR, "Missing OpenGraph namespace declaration.", htmlNode);
            return true;
        }
        return false;
    }
}

