/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.http;

import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.http.HTTPClientConfiguration;

public class DefaultHTTPClientConfiguration
implements HTTPClientConfiguration {
    private static DefaultHTTPClientConfiguration instance;
    private String userAgent;
    private int defaultTimeout;
    private int maxConnections;
    private String acceptHeader;

    public static DefaultHTTPClientConfiguration singleton() {
        if (instance == null) {
            instance = new DefaultHTTPClientConfiguration();
        }
        return instance;
    }

    public DefaultHTTPClientConfiguration(String userAgent, int defaultTimeout, int maxConnections, String acceptHeader) {
        if (userAgent == null) {
            throw new IllegalArgumentException("userAgent cannot be null.");
        }
        if (defaultTimeout <= 0) {
            throw new IllegalArgumentException("defaultTimeout cannot be <= 0 .");
        }
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("maxConnections cannot be <= 0 .");
        }
        this.userAgent = userAgent;
        this.defaultTimeout = defaultTimeout;
        this.maxConnections = maxConnections;
        this.acceptHeader = acceptHeader;
    }

    public DefaultHTTPClientConfiguration(String acceptHeader) {
        this(DefaultConfiguration.singleton().getPropertyOrFail("any23.http.user.agent.default"), DefaultConfiguration.singleton().getPropertyIntOrFail("any23.http.client.timeout"), DefaultConfiguration.singleton().getPropertyIntOrFail("any23.http.client.max.connections"), acceptHeader);
    }

    public DefaultHTTPClientConfiguration() {
        this(null);
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public String getAcceptHeader() {
        return this.acceptHeader;
    }
}

