/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.xpath;

import org.apache.any23.extractor.xpath.Term;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class TemplateSubject
extends Term<Resource> {
    private final Type type;

    public TemplateSubject(Type type, String value, boolean isVar) {
        super(value, isVar);
        if (type == null) {
            throw new NullPointerException("object type cannot be null.");
        }
        this.type = type;
    }

    @Override
    protected Resource getValueInternal(String value) {
        switch (this.type) {
            case URI: {
                return SimpleValueFactory.getInstance().createIRI(value);
            }
            case BNODE: {
                return SimpleValueFactory.getInstance().createBNode(value);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String toString() {
        String superStr = super.toString();
        switch (this.type) {
            case URI: {
                return "<" + superStr + ">";
            }
            case BNODE: {
                return "_:" + superStr;
            }
        }
        throw new IllegalStateException();
    }

    public static enum Type {
        URI,
        BNODE;

    }
}

