/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdfa;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeVisitor;
import org.semarglproject.sink.XmlSink;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

class JsoupScanner
implements NodeVisitor {
    private final NamespaceSupport ns = new NamespaceSupport();
    private final AttributesImpl attrs = new AttributesImpl();
    private final String[] nameParts = new String[3];
    private final XmlSink handler;
    private static final String[] commonHashDelimitedVocabs = new String[]{"http://creativecommons.org/ns", "http://www.w3.org/2002/07/owl", "http://www.w3.org/1999/02/22-rdf-syntax-ns", "http://www.w3.org/ns/rdfa", "http://www.w3.org/2000/01/rdf-schema", "http://www.w3.org/1999/xhtml/vocab", "http://www.w3.org/2001/XMLSchema", "http://microformats.org/profile/hcard", "http://www.w3.org/2006/vcard/ns", "http://ogp.me/ns", "http://ogp.me/ns/music", "http://ogp.me/ns/video", "http://ogp.me/ns/article", "http://ogp.me/ns/book", "http://ogp.me/ns/profile", "http://ogp.me/ns/website"};

    JsoupScanner(XmlSink handler) {
        this.handler = handler;
    }

    private static String orEmpty(String str) {
        return str == null ? "" : str;
    }

    private void startElement(Element e) throws SAXException {
        Object value;
        String name;
        this.ns.pushContext();
        this.attrs.clear();
        ArrayList<String> remainingAttrs = new ArrayList<String>();
        for (Attribute attr : e.attributes()) {
            name = attr.getKey();
            value = attr.getValue();
            if (name.startsWith("xmlns")) {
                if (name.length() == 5) {
                    this.ns.declarePrefix("", (String)value);
                    this.handler.startPrefixMapping("", (String)value);
                    continue;
                }
                if (name.charAt(5) == ':') {
                    String localName = name.substring(6);
                    this.ns.declarePrefix(localName, (String)value);
                    this.handler.startPrefixMapping(localName, (String)value);
                    continue;
                }
            } else if (name.equalsIgnoreCase("vocab")) {
                char lastChar;
                name = "vocab";
                int len = ((String)(value = ((String)value).trim())).length();
                if (len != 0 && (lastChar = ((String)value).charAt(len - 1)) != '/' && lastChar != '#' && lastChar != ':') {
                    value = ArrayUtils.contains((Object[])commonHashDelimitedVocabs, (Object)value) ? (String)value + "#" : (String)value + "/";
                }
            }
            remainingAttrs.add(name);
            remainingAttrs.add((String)value);
        }
        int len = remainingAttrs.size();
        for (int i = 0; i < len; i += 2) {
            name = (String)remainingAttrs.get(i);
            value = (String)remainingAttrs.get(i + 1);
            String[] parts = this.ns.processName(name, this.nameParts, true);
            if (parts == null) continue;
            this.attrs.addAttribute(JsoupScanner.orEmpty(parts[0]), JsoupScanner.orEmpty(parts[1]), parts[2], "CDATA", (String)value);
        }
        String qName = e.tagName();
        String[] parts = this.ns.processName(qName, this.nameParts, false);
        if (parts == null) {
            this.handler.startElement("", "", qName, (Attributes)this.attrs);
        } else {
            this.handler.startElement(JsoupScanner.orEmpty(parts[0]), JsoupScanner.orEmpty(parts[1]), parts[2], (Attributes)this.attrs);
        }
    }

    private void endElement(Element e) throws SAXException {
        String qName = e.tagName();
        String[] parts = this.ns.processName(qName, this.nameParts, false);
        if (parts == null) {
            this.handler.endElement("", "", qName);
        } else {
            this.handler.endElement(JsoupScanner.orEmpty(parts[0]), JsoupScanner.orEmpty(parts[1]), parts[2]);
        }
        for (Attribute attr : e.attributes()) {
            String name = attr.getKey();
            if (!name.startsWith("xmlns")) continue;
            if (name.length() == 5) {
                this.handler.endPrefixMapping("");
                continue;
            }
            if (name.charAt(5) != ':') continue;
            String localName = name.substring(6);
            this.handler.endPrefixMapping(localName);
        }
        this.ns.popContext();
    }

    private void handleText(String str) throws SAXException {
        this.handler.characters(str.toCharArray(), 0, str.length());
    }

    private void handleComment(String str) throws SAXException {
        this.handler.comment(str.toCharArray(), 0, str.length());
    }

    public void head(Node node, int depth) {
        try {
            if (node instanceof Element) {
                this.startElement((Element)node);
            } else if (node instanceof CDataNode) {
                this.handler.startCDATA();
                this.handleText(((CDataNode)node).text());
            } else if (node instanceof TextNode) {
                this.handleText(((TextNode)node).text());
            } else if (node instanceof Comment) {
                this.handleComment(((Comment)node).getData());
            }
        }
        catch (SAXException e) {
            JsoupScanner.sneakyThrow(e);
        }
    }

    public void tail(Node node, int depth) {
        try {
            if (node instanceof Element) {
                this.endElement((Element)node);
            } else if (node instanceof CDataNode) {
                this.handler.endCDATA();
            }
        }
        catch (SAXException e) {
            JsoupScanner.sneakyThrow(e);
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

