/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdfa;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.extractor.rdf.BaseRDFExtractor;
import org.apache.any23.extractor.rdfa.JsoupScanner;
import org.apache.any23.extractor.rdfa.SemarglSink;
import org.apache.any23.rdf.Any23ValueFactoryWrapper;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.helpers.RDFaParserSettings;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.select.NodeVisitor;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.rdf4j.rdf.rdfa.SemarglParserSettings;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.sink.XmlSink;

abstract class BaseRDFaExtractor
extends BaseRDFExtractor {
    private final short version;

    BaseRDFaExtractor(short version) {
        super(false, false);
        this.version = version;
    }

    @Override
    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, InputStream in, ExtractionResult extractionResult) throws IOException, ExtractionException {
        SemarglSink rdfaSink = new SemarglSink(extractionResult, new Any23ValueFactoryWrapper((ValueFactory)SimpleValueFactory.getInstance(), (IssueReport)extractionResult, extractionContext.getDefaultLanguage()));
        XmlSink xmlSink = RdfaParser.connect((TripleSink)rdfaSink);
        xmlSink.setProperty("http://semarglproject.org/core/properties/processor-graph-handler", (Object)rdfaSink);
        xmlSink.setProperty("http://semarglproject.org/rdfa/properties/version", (Object)this.version);
        xmlSink.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", RDFaParserSettings.VOCAB_EXPANSION_ENABLED.getDefaultValue());
        xmlSink.setProperty("http://semarglproject.org/rdfa/properties/enable-processor-graph", SemarglParserSettings.PROCESSOR_GRAPH_ENABLED.getDefaultValue());
        String baseUri = extractionContext.getDocumentIRI().stringValue();
        xmlSink.setBaseUri(baseUri);
        Document doc = Jsoup.parse((InputStream)in, null, (String)baseUri, (Parser)Parser.htmlParser().settings(ParseSettings.preserveCase));
        try {
            xmlSink.startDocument();
            doc.traverse((NodeVisitor)new JsoupScanner(xmlSink));
            xmlSink.endDocument();
        }
        catch (Exception e) {
            extractionResult.notifyIssue(IssueReport.IssueLevel.FATAL, BaseRDFaExtractor.toString(e), -1L, -1L);
        }
    }

    private static String toString(Throwable th) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            th.printStackTrace(pw);
        }
        String string = writer.toString();
        if (string.length() > 1024) {
            return string.substring(0, 1021) + "...";
        }
        return string;
    }
}

