/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.rdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.IssueReport;
import org.eclipse.rdf4j.rio.RDFParser;

public abstract class BaseRDFExtractor
implements Extractor.ContentExtractor {
    private boolean verifyDataType;
    private boolean stopAtFirstError;

    public BaseRDFExtractor() {
        this(false, false);
    }

    public BaseRDFExtractor(boolean verifyDataType, boolean stopAtFirstError) {
        this.verifyDataType = verifyDataType;
        this.stopAtFirstError = stopAtFirstError;
    }

    protected abstract RDFParser getParser(ExtractionContext var1, ExtractionResult var2);

    public boolean isVerifyDataType() {
        return this.verifyDataType;
    }

    public void setVerifyDataType(boolean verifyDataType) {
        this.verifyDataType = verifyDataType;
    }

    public boolean isStopAtFirstError() {
        return this.stopAtFirstError;
    }

    public void setStopAtFirstError(boolean b) {
        this.stopAtFirstError = b;
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext extractionContext, InputStream in, ExtractionResult extractionResult) throws IOException, ExtractionException {
        try {
            RDFParser parser = this.getParser(extractionContext, extractionResult);
            parser.parse(in, extractionContext.getDocumentIRI().stringValue());
        }
        catch (Exception ex) {
            extractionResult.notifyIssue(IssueReport.IssueLevel.FATAL, BaseRDFExtractor.toString(ex), -1L, -1L);
        }
    }

    static String toString(Throwable th) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            th.printStackTrace(pw);
        }
        String string = writer.toString();
        if (string.length() > 1024) {
            return string.substring(0, 1021) + "...";
        }
        return string;
    }
}

