/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.html.microformats2;

import java.util.List;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.html.EntityBasedMicroformatExtractor;
import org.apache.any23.extractor.html.HTMLDocument;
import org.apache.any23.extractor.html.microformats2.HCardExtractor;
import org.apache.any23.extractor.html.microformats2.HCardExtractorFactory;
import org.apache.any23.extractor.html.microformats2.HEntryExtractorFactory;
import org.apache.any23.vocab.HEntry;
import org.apache.any23.vocab.VCard;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.w3c.dom.Node;

public class HEntryExtractor
extends EntityBasedMicroformatExtractor {
    private static final HEntry vEntry = HEntry.getInstance();
    private static final VCard vVCARD = VCard.getInstance();
    private static final String[] entryFields = new String[]{"name", "summary", "content", "published", "updated", "category", "url", "uid", "syndication", "in-reply-to", "author", "location"};
    private static final String[] geoFields = new String[]{"latitude", "longitude", "altitude"};

    @Override
    public ExtractorDescription getDescription() {
        return HEntryExtractorFactory.getDescriptionInstance();
    }

    @Override
    protected String getBaseClassName() {
        return "h-entry";
    }

    @Override
    protected void resetExtractor() {
    }

    @Override
    protected boolean extractEntity(Node node, ExtractionResult out) throws ExtractionException {
        BNode entry = this.getBlankNodeFor(node);
        this.conditionallyAddResourceProperty((Resource)entry, RDF.TYPE, HEntryExtractor.vEntry.Entry);
        HTMLDocument fragment = new HTMLDocument(node);
        this.addName(fragment, entry);
        this.addSummary(fragment, entry);
        this.addContent(fragment, entry);
        this.addPublished(fragment, entry);
        this.addUpdated(fragment, entry);
        this.addCategories(fragment, entry);
        this.addURLs(fragment, entry);
        this.addUID(fragment, entry);
        this.addSyndications(fragment, entry);
        this.addInReplyTo(fragment, entry);
        this.addLocations(fragment, (Resource)entry);
        this.addAuthors(fragment, (Resource)entry);
        return true;
    }

    private void addAuthors(HTMLDocument doc, Resource entry) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + entryFields[10] + " h-card");
        if (nodes.isEmpty()) {
            return;
        }
        HCardExtractorFactory factory = new HCardExtractorFactory();
        HCardExtractor extractor = factory.createExtractor();
        for (Node node : nodes) {
            BNode author = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)author, RDF.TYPE, HEntryExtractor.vEntry.author);
            extractor.extractEntityAsEmbeddedProperty(new HTMLDocument(node), author, this.getCurrentExtractionResult());
        }
    }

    private void mapFieldWithProperty(HTMLDocument fragment, BNode entry, String fieldClass, IRI property) {
        HTMLDocument.TextField title = fragment.getSingularTextField(fieldClass);
        this.conditionallyAddStringProperty(title.source(), (Resource)entry, property, title.value());
    }

    private void addName(HTMLDocument fragment, BNode entry) {
        this.mapFieldWithProperty(fragment, entry, "p-" + entryFields[0], HEntryExtractor.vEntry.name);
    }

    private void addSummary(HTMLDocument fragment, BNode entry) {
        this.mapFieldWithProperty(fragment, entry, "p-" + entryFields[1], HEntryExtractor.vEntry.summary);
    }

    private void addContent(HTMLDocument fragment, BNode entry) {
        this.mapFieldWithProperty(fragment, entry, "e-" + entryFields[2], HEntryExtractor.vEntry.content);
    }

    private void addPublished(HTMLDocument fragment, BNode entry) {
        HTMLDocument.TextField[] durations;
        for (HTMLDocument.TextField duration : durations = fragment.getPluralTextField("dt-" + entryFields[3])) {
            Node attribute = duration.source().getAttributes().getNamedItem("datetime");
            if (attribute == null) {
                this.conditionallyAddStringProperty(duration.source(), (Resource)entry, HEntryExtractor.vEntry.published, duration.value());
                continue;
            }
            this.conditionallyAddStringProperty(duration.source(), (Resource)entry, HEntryExtractor.vEntry.published, attribute.getNodeValue());
        }
    }

    private void addUpdated(HTMLDocument fragment, BNode entry) {
        HTMLDocument.TextField[] durations;
        for (HTMLDocument.TextField duration : durations = fragment.getPluralTextField("dt-" + entryFields[4])) {
            Node attribute = duration.source().getAttributes().getNamedItem("datetime");
            if (attribute == null) {
                this.conditionallyAddStringProperty(duration.source(), (Resource)entry, HEntryExtractor.vEntry.updated, duration.value());
                continue;
            }
            this.conditionallyAddStringProperty(duration.source(), (Resource)entry, HEntryExtractor.vEntry.updated, attribute.getNodeValue());
        }
    }

    private void addCategories(HTMLDocument fragment, BNode entry) {
        HTMLDocument.TextField[] categories;
        for (HTMLDocument.TextField category : categories = fragment.getPluralTextField("p-" + entryFields[5])) {
            this.conditionallyAddStringProperty(category.source(), (Resource)entry, HEntryExtractor.vEntry.category, category.value());
        }
    }

    private void addURLs(HTMLDocument fragment, BNode entry) throws ExtractionException {
        HTMLDocument.TextField[] urls;
        for (HTMLDocument.TextField url : urls = fragment.getPluralUrlField("u-" + entryFields[6])) {
            this.addIRIProperty((Resource)entry, HEntryExtractor.vEntry.url, fragment.resolveIRI(url.value()));
        }
    }

    private void addUID(HTMLDocument fragment, BNode entry) throws ExtractionException {
        HTMLDocument.TextField uid = fragment.getSingularTextField("u-" + entryFields[7]);
        if (uid.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)entry, HEntryExtractor.vEntry.uid, fragment.resolveIRI(uid.value()));
    }

    private void addSyndications(HTMLDocument fragment, BNode entry) throws ExtractionException {
        HTMLDocument.TextField[] syndications;
        for (HTMLDocument.TextField syndication : syndications = fragment.getPluralUrlField("u-" + entryFields[8])) {
            this.addIRIProperty((Resource)entry, HEntryExtractor.vEntry.syndication, fragment.resolveIRI(syndication.value()));
        }
    }

    private void addInReplyTo(HTMLDocument fragment, BNode entry) throws ExtractionException {
        HTMLDocument.TextField inReplyTo = fragment.getSingularTextField("u-" + entryFields[9]);
        if (inReplyTo.source() == null) {
            return;
        }
        this.addIRIProperty((Resource)entry, HEntryExtractor.vEntry.in_reply_to, fragment.resolveIRI(inReplyTo.value()));
    }

    private void addLocations(HTMLDocument doc, Resource entry) throws ExtractionException {
        List<Node> nodes = doc.findAllByClassName("p-" + entryFields[11] + " h-geo");
        if (nodes.isEmpty()) {
            return;
        }
        for (Node node : nodes) {
            BNode location = this.valueFactory.createBNode();
            this.addIRIProperty((Resource)location, RDF.TYPE, HEntryExtractor.vEntry.location);
            HTMLDocument fragment = new HTMLDocument(node);
            for (String field : geoFields) {
                HTMLDocument.TextField[] values;
                for (HTMLDocument.TextField val : values = fragment.getPluralTextField("p-" + field)) {
                    Node attribute = val.source().getAttributes().getNamedItem("title");
                    if (attribute == null) {
                        this.conditionallyAddStringProperty(val.source(), (Resource)location, vVCARD.getProperty(field), val.value());
                        continue;
                    }
                    this.conditionallyAddStringProperty(val.source(), (Resource)location, vVCARD.getProperty(field), attribute.getNodeValue());
                }
            }
        }
    }
}

